# Billing Software

# About Project 
This is  a simple billing software that allows users to create invoices, add products, and cash receipts.

# Requirement
- PHP >= 8.2
- Laravel >= 11
- MySQL
- Composer

## Installation Instruction

1. Clone the repository :
    ```bash
    git clone https://github.com/ramkumawathis/billingSoftware.git
    ```

2. Navigate to the project directory:
   ```bash
   cd billingSoftware
   ```

3. Install PHP dependencies:
   ```bash
   composer install
   ```

4. Set up the environment variables by copying `.env.example` to `.env` and configuring the necessary variables:
   ```bash
   cp .env.example .env
   ``

5. Generate an application key:
   ```bash
   php artisan key:generate
   ```

6. Run database migrations:
   ```bash
   php artisan migrate
   ```

7. (Optional) Seed the database with dummy data:
   ```bash
   php artisan db:seed
   ```

8. Start the local development server:
   ```bash
   php artisan serve
   ```

```markdown
## Configuration
Make sure to set the following in your `.env` file:

- `DB_CONNECTION=mysql`
- `DB_HOST=127.0.0.1`
- `DB_PORT=3306`
- `DB_DATABASE=your_database`
- `DB_USERNAME=your_username`
- `DB_PASSWORD=your_password`


```markdown
## Features
- User authentication and registration
- User Profile & Reset Password
- Role-based access control
- Staff Management
- Inventory Management
- Product Management [With Brand Master , Unit Master]
- Customer Management [With Area Master]
- Invoice Management
- Cash Receipt Management
- Cash Management for Staff
- Settings
- Print Functionalities