<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\CashBalanceRecord;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Models\CashManagement;
use App\Models\PaymentTransaction;
use Illuminate\Support\Facades\DB;

class CashBalanceController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function index()
    {
        abort_if(Gate::denies('cash_balance_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $openingBalance = 0;
        try {
            return view('admin.cash_balance.index',compact('openingBalance'));
        }catch (\Exception $e) {
            return abort(400);
        }
    }

    public function cashLedgerRecords(Request $request){
        abort_if(Gate::denies('cash_balance_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        try {

            // dd($request->all());
            $year = $request->input('year', date('Y'));
            $monthWiseData = [];
            $currentMonth = Carbon::now()->month; // Get the current month

            // Loop through months, but limit the number of months if the current year is selected
            $monthsToLoop = ($year == date('Y')) ? $currentMonth : 12;
            for ($month = 1; $month <= $monthsToLoop; $month++) {
                $monthKey = Carbon::create($year, $month, 1)->format('Y-m');
                $monthWiseData[$monthKey] = [
                    'month' => $monthKey,
                    'total_debit' => 0,
                    'total_credit' => 0
                ];
            }        

            $cashBalanceData = CashBalanceRecord::with('recordable')
                ->whereYear('created_date', $year)
                ->get();

            foreach ($cashBalanceData as $record) {
                $monthKey = $record->created_date->format('Y-m');                
                $recordableAmount = $record->recordable->amount ?? 0; 
                // Update month-wise data
                if ($record->transaction_type == 'debit') {
                    $monthWiseData[$monthKey]['total_debit'] += $recordableAmount;
                } elseif ($record->transaction_type == 'credit') {
                    $monthWiseData[$monthKey]['total_credit'] += $recordableAmount;
                }
            }

            $alldata = array_values($monthWiseData);
            $openingBalance = 0;
            // dd($alldata);

            $htmlView = view('admin.cash_balance.table-records',compact('openingBalance','alldata'))->render();
            return response()->json(['success' => true, 'htmlView' => $htmlView]);
        }catch (\Exception $e) {
            dd($e->getMessage());
            return abort(400);
        }
    }

    public function cashLedgerRecordsOld(Request $request){
        abort_if(Gate::denies('cash_balance_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        try {
            $alldata = CashBalanceRecord::query();

            //Apply filters
            $month = $request->input('month');
            $year = $request->input('year');

            if ($month) {
                $alldata = $alldata->whereMonth('created_date', $month);
            }

            if ($year) {
                $alldata = $alldata->whereYear('created_date', $year);
            }

            $alldata = $alldata->get();

            $openingBalance = 0;
            $htmlView = view('admin.cash_balance.table-records',compact('openingBalance','alldata'))->render();
            return response()->json(['success' => true, 'htmlView' => $htmlView]);
        }catch (\Exception $e) {
            return abort(400);
        }
    }

    public function viewCashLedgerDetail(Request $request){
        abort_if(Gate::denies('cash_balance_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $alldata = CashBalanceRecord::query();

        //Apply filters
        $month = $request->input('month') ? Carbon::createFromFormat('m', $request->input('month')) : null;
        $year = $request->input('year') ? Carbon::createFromFormat('Y', $request->input('year')) : null;

        if ($month) {
            $alldata = $alldata->whereMonth('created_date', $month);
        }

        if ($year) {
            $alldata = $alldata->whereYear('created_date', $year);
        }

        $alldata = $alldata->get();
        $openingBalance = 0;
        $formattedMonthYear = $month && $year ? $month->format('F') . ' ' . $year->format('Y') : '';
        return view('admin.cash_balance.view',compact('openingBalance','alldata','formattedMonthYear'));
    }


    public function show(CashBalanceRecord $cashLedger){
        abort_if(Gate::denies('cash_balance_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $record_type = $cashLedger->record_type;
        $record = $cashLedger->recordable;
        $htmlView = view('admin.cash_balance.show',compact('record_type','record'))->render();
        return response()->json(['success' => true, 'htmlView' => $htmlView]);
    }






}
