<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\UnitTypeDataTable;
use App\Http\Controllers\Controller;
use App\Models\UnitType;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class UnitTypeController extends Controller
{
    public function index(UnitTypeDataTable $dataTable)
    {
        abort_if(Gate::denies('unit_access'), Response::HTTP_FORBIDDEN, '403 Forbidden'); 
        return $dataTable->render('admin.unit_type.index');
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {  
        abort_if(Gate::denies('unit_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $validator = Validator::make($request->all(), [
            'name' => [
                'required',
                Rule::unique('unit_types', 'name')->whereNull('deleted_at'),
            ]]); 
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
        $unit_data = UnitType::create(['name' => $request->name,'created_by'=> Auth::id()]); 
        addToLog($request,'UnitType','Create', $unit_data);
        $unitList = UnitType::all();
        return response()->json(['success' => 'Unit Created Successfully.', 'unitData' => $unit_data, 'unitList' => $unitList]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(Gate::denies('unit_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $id =  decrypt($id);
        $validator = Validator::make($request->all(), [
            'name' => [
                'required',
                Rule::unique('unit_types', 'name')->ignore($id)->whereNull('deleted_at'),
            ]]);  
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
        $unitData =  UnitType::find($id);
        $oldvalue = $unitData->getOriginal();         
        $unitData->name = $request->name;
        $unitData->updated_by = Auth::id();
        $unitData->save();       
        $newValue = $unitData->refresh();
        addToLog($request,'UnitType','Edit', $newValue ,$oldvalue);        
        return response()->json(['success' => 'Unit Updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, string $id)
    {
        abort_if(Gate::denies('unit_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $record = UnitType::find(decrypt($id));
        $oldvalue = $record->getOriginal(); 
        $record->updated_by = Auth::id();
        $record->save();
        $newValue = $record->refresh();
        addToLog($request,'UnitType','Delete', $newValue ,$oldvalue);
        $record->delete();
        return response()->json(['success' => 'Unit Deleted successfully.']);
    }
}
