<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\ResetPasswordMail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Rules\IsActive;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class ForgotPasswordController extends Controller
{
    //
    public function index(){
        return view('auth.forgot-password');
    }

    public function sendResetLinkEmail(Request $request){

        $validated = $request->validate(['email' => ['required','email','exists:users',new IsActive]], getCommonValidationRuleMsgs());       
        try{
            $user = User::where('email',$request->email)->first();

            DB::table('password_reset_tokens')->where(['email'=> $request->email])->delete();
            
            $token = generateRandomString(32);
            $email_id = $request->email;
            $reset_password_url=route('resetPassword',[$token,encrypt($email_id)]);
            DB::table('password_reset_tokens')->insert([
                'email' => $email_id,
                'token' => $token,
                'created_at' => Carbon::now()
            ]);

            Mail::to($email_id)->send(new ResetPasswordMail($user,$reset_password_url));  
            
            return response()->json([
                'success' => true,
                'message' => trans('passwords.sent'),
                'alert-type'=> trans('quickadmin.alert-type.success'),                    
            ], 200);            

        }catch(\Exception $e){           
            dd($e->getMessage().'->'.$e->getLine());
            return response()->json(['success' => false,
            'message' => trans('quickadmin.qa_reset_password_woops'),
            'alert-type'=> trans('quickadmin.alert-type.error')], 500);
        }
    }
}
