<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Rules\IsActive;
use Illuminate\Support\Facades\Cookie;

class LoginController extends Controller
{
    public function index()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $credentialsOnly = $request->validate([
            'email'    => ['required','string',new IsActive],
            'password' => ['required','string','min:8'],
        ]);

        $remember_me = !is_null($request->remember_me) ? true : false;
        $user = User::where('email',$request->email)->first();
        if($user){
            if (Auth::attempt($credentialsOnly, $remember_me))
            {                 
                addToLog($request,'User','Login successfully');               
                if ($remember_me) {
                    Cookie::queue('remembered_email', $request->email, 43200); // 30 days
                    Cookie::queue('remembered_password', $request->password, 43200);
                } else {
                    Cookie::queue(Cookie::forget('remembered_email'));
                    Cookie::queue(Cookie::forget('remembered_password'));
                }
                return response()->json([
                    'success' => true,
                    'message' => trans('messages.crud.add_record'),
                    'alert-type'=> trans('quickadmin.alert-type.success'),
                    'title' => 'Login',
                    'redirect_url' => route('dashboard'),
                ], 200);                    
            }else{
                return response()->json([
                    'success' => false,
                    'message' => trans('auth.failed'),
                    'alert-type'=> trans('quickadmin.alert-type.error'),
                    'title' => 'Wrong Credentials !',
                ], 500);  
            }                               
        }else{
            return response()->json([
                'success' => false,
                'message' => trans('auth.unauthorize'),
                'alert-type'=> trans('quickadmin.alert-type.error'),
                'title' => 'Wrong Credentials !',
            ], 500);
        }        
    }

    public function logout(Request $request)
    {
        Auth::guard('web')->logout();
        $request->session()->forget('password_entered');
        addToLog($request,'User','Logout successfully');
        return redirect()->route('login');
    }

}
