<?php
namespace App\Http\Requests\CashManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class StoreUpdateCashManagementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
       // abort_if(Gate::denies('transaction_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {        
        $isSuperAdmin = auth()->user()->hasRole(config('app.roleid.super_admin'));  

        $userId = auth()->user()->id;

        $data =  [
            'user_id'       => 'required|exists:users,id',
            'payment_way'   => 'required|in:by_cash,by_check,by_account',
            'amount'        => 'required|regex:/^\d+(\.\d{1,4})?$/',            
            'entry_date'    => 'required|date',
            'remark'        => 'nullable|string|max:255',
        ];

       if(!$isSuperAdmin){
            $data['user_id'] =  'required|exists:users,id|in:' . $userId;
            $data['payment_way'] = 'required|in:by_cash';
       }

        if ($this->isMethod('PUT') || $this->isMethod('patch')) {
           $uuid = $this->route('cash_management');
           $uuid = $uuid->uuid;           
           $data['voucher_number'] = 'nullable|unique:cash_management,voucher_number,' . $uuid . ',uuid';
        } else {
            $data['voucher_number'] = 'nullable|unique:cash_management,voucher_number';
        }    
        return $data;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return [
            //'extra_details.required_unless'  => 'The check/account number field is required, if payment mode is in by check or by account.',
        ];
    }

}
