<?php

namespace App\Http\Requests\Inventory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        abort_if(Gate::denies('inventory_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return true;
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return  [
            'product_id'    => 'required|numeric|exists:products,id,deleted_at,NULL',
            'quantity'      => 'required|numeric',
            'entry_date'    => 'required|date',
            'remark'        => 'nullable|string|max:255',
            'place'        => 'required|string',
           // 'is_active'     => 'required | in:1,0',            
        ];
    }

    public function messages()
    {
        return [
            'product_id.required'   => 'The Product is required.',
            'place.required'      => 'The Place is required.',
        ];
    }

    public function attributes()
    {
        return [
            'product_id'    => 'Product',
            'place'       => 'Place',
            'entry_date'    => 'Date',
           // 'is_active'     => 'Status',
        ];

    }
}
