<?php

namespace App\Http\Requests\Inventory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use App\Rules\InventoryValidationRule;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        abort_if(Gate::denies('inventory_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return true;
    }


    // public function rules(): array
    // {
    //     return  [
    //         'product_id'    => 'required|numeric|exists:products,id,deleted_at,NULL',           
    //         'quantity'      => 'required|numeric',
    //         'entry_date'    => 'required|date',
    //         'remark'        => 'required|string',
    //         'place'        => 'required|string',
    //        // 'is_active'     => 'required | in:1,0',            
    //     ];
    // }

 

    public function rules(): array
    {

       return [
            'product_id' => ['required','numeric','exists:products,id,deleted_at,NULL',new InventoryValidationRule($this->input('product_id'), 'product_exists')],
             'quantity' => ['required','numeric',new InventoryValidationRule($this->input('quantity'), 'check_quantity', ['product_id' => $this->input('product_id'),'id' => $this->route('inventory')->uuid, 'place' => $this->input('place')])],
            'entry_date' => 'required|date',
            'remark' => 'nullable|string|max:255',
            'place' => 'required|string',
         ];
    }

    // public function messages()
    // {
    //     return [
    //         'product_id.required'   => 'The Product is required.',
    //     ];
    // }

    // public function attributes()
    // {
    //     return [
    //         'product_id'    => 'Product',
    //         'entry_date'    => 'Date',
    //        // 'is_active'     => 'Status',
    //     ];

    // }

}
