<?php
namespace App\Http\Requests\PaymentTransactions;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class StoreUpdatePaymentTransactionsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        abort_if(Gate::denies('transaction_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {        
        $data =  [
            'customer_id'       => 'required|exists:customers,id',

            'payment_way'   => 'required|array',
            'payment_way.*' => 'required|in:by_cash,by_phonepay,by_check,by_account',

            'amount'        => 'required|array',
            'amount.*'      => 'required|regex:/^\d+(\.\d{1,4})?$/',
            // 'extra_details'   => 'required_unless:payment_way,by_cash',          
            'entry_date'        => 'required|date',
            'remark'            => 'nullable|string|max:255',
        ];

        $customerId = $this->input('customer_id');
        $customer = \App\Models\Customer::find($customerId);

        if ($customer && $customer->customer_type === 'cash') {
            $data['voucher_number'] = 'nullable|unique:payment_transactions,voucher_number';
        } else {
            if ($this->isMethod('put') || $this->isMethod('patch')) {
                $data['voucher_number'] = 'required|unique:payment_transactions,voucher_number,' . $this->uuid . ',uuid';
            } else {
                $data['voucher_number'] = 'required|unique:payment_transactions,voucher_number';
            }
        }
        return $data;
    }

    
    public function attributes()
    {
        return [
            'voucher_number' => 'Estimate number',
        ];
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return [
            //'extra_details.required_unless'  => 'The check/account number field is required, if payment mode is in by check or by account.',
            'amount.*.required' => 'The amount field is required.',
            'payment_way.*.required' => 'The payment way field is required.',

        ];
    }

}
