<?php

namespace App\Http\Requests\ShiftingGood;
use Illuminate\Foundation\Http\FormRequest;


class StoreRequest extends FormRequest
{

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return  [
            'product_id'    => 'required|numeric|exists:products,id,deleted_at,NULL',
            'entry_date'    => 'required|date',
            'from'        => 'required|string',
            'to'        => 'required|string',   
            'quantity'      => 'required|numeric',
        ];
    }

    public function messages()
    {
        return [
            'product_id.required'   => 'The product is required.',
            'from.required'      => 'The location from is required.',
            'to.required'      => 'The location to is required.',
        ];
    }

    public function attributes()
    {
        return [
            'product_id'    => 'Product',
            'from'       => 'From',
            'to'       => 'To',
            'entry_date'    => 'Ship Date',
        ];

    }
}
