<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CashBalanceRecord extends Model
{
    protected $fillable = [
        'record_id',
        'record_type',
        'transaction_type',
        'created_date',
        'created_by',
    ];

    protected $casts = [
        'created_date' => 'date',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function(CashBalanceRecord $model) {
            $model->created_by = auth()->user()->id;
        });

    }


    /**
     * Define a polymorphic relationship.
     */
    public function recordable()
    {
        return $this->morphTo(null, 'record_type', 'record_id');
    }

    /**
     * Relationship with the User model.
     */
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get particulars based on the record_type.
     */
    public function getParticularsAttribute()
    {
        switch ($this->record_type) {
            case PaymentTransaction::class:

                if($this->recordable->payment_way == 'by_cash' && $this->recordable->generated_from == 'Order'){
                    return 'Cash Sales';
                }

                if($this->recordable->payment_way == 'by_cash' && $this->recordable->generated_from == 'Cash'){
                    return 'Cash Receipt ('.$this->recordable->voucher_number.')';
                }

                return '';
            case CashManagement::class:
                return 'Cash Out ('.$this->recordable->voucher_number.')';
            default:
                return '';
        }
    }
}
