<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CashManagement extends Model
{
    use SoftDeletes, UuidTrait;


    protected $fillable = [
        'uuid',
        'user_id',
        'voucher_number',
        'payment_way',
        'remark',
        'amount',
        'entry_date',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    protected static function boot()
    {
        parent::boot();
        static::creating(function(CashManagement $model) {
            $model->created_by = auth()->user()->id;
        });

        static::deleting(function(CashManagement $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });

        static::updating(function(CashManagement $model) {
            $model->updated_by = auth()->user()->id;
        });
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Polymorphic relationship with CashBalanceRecord.
     */
    public function cashBalanceRecords()
    {
        return $this->morphMany(CashBalanceRecord::class, 'recordable');
    }

}
