<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShiftingGood extends Model
{
    use HasFactory;

    public $timestamps = true;    

    protected $casts = [
        'entry_date' => 'date',
    ];

    protected $fillable = [
        'product_id',
        'from',      
        'to',
        'entry_date',
        'quantity'
    ];   
    
    public function product(){
        return $this->belongsTo(Product::class, 'product_id');
    }
}
