<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class UnitType extends Model
{
    use HasFactory,SoftDeletes,UuidTrait;

    protected $table = 'unit_types';
    public $timestamps = true; 
    protected $fillable = [
        'uuid',
        'name',
        'is_active',
        'created_by',
        'updated_by',
        'deleted_at',
    ];

    protected $appends = [
        'product_count',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function(UnitType $model) {
            $model->created_by = auth()->user()->id;
        });

        /*
        static::deleting(function(UnitType $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });
        */

        static::updating(function(UnitType $model) {
            $model->updated_by = auth()->user()->id;
        });
    }

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function products(){
        return $this->hasMany(Product::class, 'unit_type');
    }

    public function getProductCountAttribute()
    {
        return $this->products()->count();
    }
}
