<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_transactions', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->unsignedBigInteger('customer_id')->index();
            $table->enum('payment_type', array('credit', 'debit'))->default('credit');
            $table->enum('payment_way', array('order_create', 'order_return', 'by_cash', 'by_check', 'by_account'))->default('order_create');
            $table->string('voucher_number')->nullable()->index();
            $table->unsignedBigInteger('order_id')->nullable();
            $table->string('extra_details')->nullable();
            $table->string('remark')->nullable();
            $table->decimal('amount', 15, 2);
            $table->date('entry_date')->nullable();
            $table->tinyInteger('is_modified')->default(0)->comment('1=> modified, 0=>not_modified');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            // Foreign key constraint
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('deleted_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_transactions');
    }
};
