<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_balance_records', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('record_id'); // Reference ID
            $table->string('record_type');
            $table->enum('transaction_type', ['debit', 'credit']); // Debit or Credit (D for debit, C for credit)
            $table->date('created_date');
            $table->unsignedBigInteger('created_by'); 
            $table->timestamps();

            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_balance_records');
    }
};
