<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use App\Models\Customer;

class CustomerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $customers[0] = [
            'name'           => 'Cash Customer',
            'phone_number'   => '1111111111',
            'alternate_phone_number'  =>  null,
            'area_id'        => 1,
            'remark'         => 'For all cash payment',
            'credit_limit'   => 0,
            'customer_type'  => 'cash',
            'is_active'      => 1,
            'created_by'     => config('constant.roles.super_admin'),
            'created_at'     => date('Y-m-d H:i:s'),
            'updated_at'     => date('Y-m-d H:i:s'),
        ];
        $customers[1] = [
            'name'           => 'PhonePay Customer',
            'phone_number'   => '2222222222',
            'alternate_phone_number'  =>  null,
            'area_id'        => 1,
            'remark'         => 'For all phonepay transaction',
            'credit_limit'   => 0,
            'customer_type'  => 'phonepay',
            'is_active'      => 1,
            'created_by'     => config('constant.roles.super_admin'),
            'created_at'     => date('Y-m-d H:i:s'),
            'updated_at'     => date('Y-m-d H:i:s'),
        ];

        foreach($customers as $key=>$customer){
            $createdCustomer =  Customer::create($customer);
        }
    }
}
