
@extends('layouts.app')
@section('title')@lang('quickadmin.brand_master.title') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
@endsection
@section('main-content')

<div class="card MainBox">
  <div class="mainHeading">
    <h4>@lang('quickadmin.brand_master.title')</h4>
    <div>
      @can('brand_create')
      <button type="button" class="btn addRecordBtn addBtn add_brand" title="@lang('quickadmin.brand_master.fields.new_brand')" ><i class="fas fa-plus"></i>@lang('quickadmin.brand_master.fields.new_brand')</button>
      @endcan 
    </div>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive fixed_Search brand-table">
      {{$dataTable->table(['class' => 'table dt-responsive', 'style' => 'width:100%;'])}}
    </div>
  </div>
</div>
@include('admin.brand.add-brand')

@endsection

@section('customJS')
{!! $dataTable->scripts() !!}
<script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>
<script type="text/javascript">
    // add or edit
    $(document).ready(function(){
        var DataaTable = $('#brand-table').DataTable();
        $(document).on('click','.edit_brand',function(){
            $('.error').html('');
            $("#brandModal").modal('show');
            $(".brand_edit_id").val($(this).data('id'));
            $(".brand_edit_name").val($(this).data('name'));
            $(".save_btn").html('Update');
            $(".Add_edit_brand").html('Edit');
        })
    
        $.ajaxSetup({
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        // add or edit
        // delete
        $(document).on('click','.delete_brand',function(){
            var delete_id = $(this).data('id');
            var delete_url = "{{ route('brand.destroy',['brand'=> ':brandId']) }}";
            delete_url = delete_url.replace(':brandId', delete_id);
            swal({
                title: "Are  you sure?",
                text: "{{ trans('messages.areYouSure') }}",
                icon: 'warning',
                buttons: {
                    confirm: 'Yes, delete',
                    cancel: 'No, cancel',
                },
                dangerMode: true,
            }).then(function(willDelete) {
                if(willDelete) {  
                    $.ajax({
                    type: "DELETE",
                    url: delete_url,              
                    success: function(data) {
                        if ($.isEmptyObject(data.error)) {
                        DataaTable.ajax.reload();
                        var alertType = "{{ trans('quickadmin.alert-type.success') }}";
                        var message = "{{ trans('messages.crud.delete_record') }}";
                        var title = "Brand";
                        showToaster(title,alertType,message);                    
                        } 
                    },
                    error: function (xhr) {
                        swal("{{ trans('quickadmin.order.invoice') }}", 'Something Went Wrong!', 'error');
                    }
                    });
                }
            })
        });
        // delete
    })


</script>
@include('admin/brand/_script')
@endsection
