
@extends('layouts.app')
@section('title')@lang('quickadmin.cash-balance.title') @endsection

@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
{{-- <link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}"> --}}
<style>
</style>
@endsection
@section('main-content')
<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-nopwrap">@lang('quickadmin.cash-balance.title')</h4>

        <div class="">
            <form id="invoice-filter-form">
                <div class="cart_filter_box">
                    <div class="mx-0 datapikergroup custom-select2 floatingLabel">
                        <div class="form-control-inner form-group">
                            <label for="reportrange">Select Date</label>
                            <div id="reportrange" class="pull-right">
                                <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>&nbsp;
                                <span></span> <b class="caret"></b>
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0">
                        <button type="submit" class="btn addRecordBtn addBtn" id="apply-filter"><i class="fa fa-paper-plane" aria-hidden="true"></i>
                            @lang('quickadmin.qa_submit')
                        </button>
                        <button type="reset" class="btn addRecordBtn addBtn" id="reset-filter"><i class="fa fa-refresh" aria-hidden="true"></i>
                            @lang('quickadmin.qa_reset')
                        </button>
                    </div>
                </div>
            </form>
        </div>

    </div>
    <div class="card-body p-0">
        <div class="table-responsive fixed_Search">
            <table class="table custom_table table_Footer ledger-table">
                <thead>
                    <tr>
                        {{-- <th>@lang('quickadmin.cash-balance.fields.created_date')</th> --}}
                        <th>@lang('quickadmin.cash-balance.fields.particulars')</th>
                        <th>@lang('quickadmin.cash-balance.fields.debit')</th>
                        <th>@lang('quickadmin.cash-balance.fields.credit')</th>
                        <th>@lang('quickadmin.cash-balance.fields.balance')</th>
                        <th>@lang('quickadmin.qa_action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

@endsection
@section('customJS')
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<script type="text/javascript">
    $(function() {
        // var date = '{{ config("app.start_date")}}';
        // var start = moment(date, 'YYYY-MM-DD'); /*.moment().startOf('month')*/
        // var end = moment();

        var start = moment().startOf('month');
        var end = moment().endOf('month');
        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }

        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);

        cb(start, end);

    });
    // var defaultStartDate = moment('{{ config("app.start_date") }}', 'YYYY-MM-DD');
    // var defaultEndDate = moment();

    var defaultStartDate = moment().startOf('month');
    var defaultEndDate = moment().endOf('month');
    const filters = { from_date: defaultStartDate.format('YYYY-MM-DD'), to_date: defaultEndDate.format('YYYY-MM-DD') };

    $(document).on("click", ".view_cashreceipt", function (e) {
        e.preventDefault();
        var hrefUrl = $(this).attr('data-href');
        $.ajax({
            type: 'get',
            url: hrefUrl,
            dataType: 'json',
            success: function (response) {
                if(response.success) {
                    $('.popup_render_div').html(response.htmlView);
                    $('#viewModal').modal('show');
                }
            }
        });
    });

$(document).ready(function () {
    $('#reset-filter').on('click', function(e) {
        e.preventDefault();
        $('#invoice-filter-form')[0].reset();

        //Reset the Daterangepicker
        if ($('#reportrange').data('daterangepicker')) {
            var start = defaultStartDate ?? null;
            var end = defaultEndDate ?? null;
            $('#reportrange').data('daterangepicker').setStartDate(start);
            $('#reportrange').data('daterangepicker').setEndDate(end);
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }

        renderTable(filters);
    });

    $('#invoice-filter-form').on('submit', function(e) {
        e.preventDefault();

        var picker = $('#reportrange').data('daterangepicker');
        if (picker && picker.startDate && picker.endDate) {
            var from_date = picker.startDate.format('YYYY-MM-DD');
            var to_date = picker.endDate.format('YYYY-MM-DD');
        } else {
            var from_date = null;
            var to_date = null;
        }

        if(from_date == undefined || from_date == 'Invalid date'){
            from_date = '';
        }

        if(to_date == undefined || to_date == 'Invalid date'){
            to_date = '';
        }

        var params = {
                from_date        : from_date,
                to_date          : to_date,
        };

        renderTable(params);

    });


    renderTable(filters);

});



async function renderTable(filters = '') {
    $('.loader').css('display','block');
    try {
        const hrefUrl = "{{ route('getCashLedgerRecords') }}";
        const response = await $.ajax({
            type: 'POST',
            url: hrefUrl,
            data: filters,
            dataType: 'json'
        });

        if (response.success) {
            $('.ledger-table tbody').remove();
            $('.ledger-table tfoot').remove();
            $('.ledger-table thead').after(response.htmlView);
            $('.loader').css('display','none');
        }
    } catch (error) {
        $('.loader').css('display','none');
        console.error("An error occurred:", error);
    }
}
</script>
@endsection
