@php
  $isSuperAdmin = auth()->user()->hasRole(config('app.roleid.super_admin'));    
@endphp

<div class="row topRow2">

    @if($isSuperAdmin)
    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="voucher_number">@lang('quickadmin.transaction.fields.voucher_number')</label>
            <div class="input-group">
                <input type="text" class="form-control" name="voucher_number" value="{{ isset($cashManagement) ? $cashManagement->voucher_number : $invoice_number }}" id="voucher_number" readonly>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="user_id">@lang('quickadmin.cash-management.fields.staff')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="user_id" class="form-control select2" id="user_id">
                    <option value="" disabled selected>@lang('quickadmin.cash-management.fields.select')</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}"  {{ isset($cashManagement) ? $cashManagement->user_id == $customer->id ? 'selected' :'' :'' }} >{{ $customer->name ??'' }} {{ $customer->phone?' - '. $customer->phone:'' }} </option>
                    @endforeach
                </select>                
            </div>
        </div>
    </div>  

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="payment_way">@lang('quickadmin.transaction.fields.payment_mode')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="payment_way" class="form-control select2" id="payment_way">
                    @foreach(config('constant.payment_ways') as $key => $value)
                        <option value="{{ $key }}"  {{ isset($cashManagement) ? $cashManagement->payment_way == $key ? 'selected' :'' :'' }} >{{ $value ?? '' }} </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    @else

    <input type="hidden" name="voucher_number" value="{{ isset($cashManagement) ? $cashManagement->voucher_number : $invoice_number }}" id="voucher_number">
    <input type="hidden" name="user_id" value="{{ auth()->user()->id }}">
    <input type="hidden" name="payment_way" value="by_cash">

    @endif


    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="amount">@lang('quickadmin.transaction.fields.amount')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="amount" id="amount" min="1" step="1" value="{{ isset($cashManagement) ? $cashManagement->amount : old('amount') }}" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="@lang('quickadmin.qa_enter') @lang('quickadmin.transaction.fields.amount')">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="entry_date">@lang('quickadmin.transaction.fields.entry-date')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="entry_date" max="<?= date('Y-m-d'); ?>" id="entry_date" >
            </div>
        </div>
    </div>

    <div class="col-md-12 col-lg-12">        
        <div class="form-group">
            <label for="remark">@lang('quickadmin.transaction.fields.remark')</label>
            <div class="input-group">
                <input type="text" placeholder="Enter Remark" id="remark" class="form-control" name="remark" value="{{ isset($cashManagement) ? $cashManagement->remark : old('remark') }}" tabindex="1">
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl-12">        
        <div class="">
            <button type="submit" class="btn btn-submit-block btn-lg btn-block ml-auto" title="@lang('quickadmin.qa_save')">@lang('quickadmin.qa_save')</button>
        </div>
    </div>
    
</div>

   
    
