<script src="{{ asset('admintheme/assets/js/moment.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/js/daterangepicker.min.js') }}"></script>
<script>        
    function initializeInvoiceDatePicker(entryDate = null) {
        @if(isset($cashManagement))
            entryDate = '{{ $cashManagement->entry_date }}';
        @endif
        const dateFormat = "{{ config('constant.js_date_format.date') }}";
        $('#entry_date').daterangepicker({
            locale: { format: dateFormat },
            singleDatePicker: true,
            autoUpdateInput: true,
            autoApply: true,
            startDate:  entryDate ? moment(entryDate) : moment(),
        });
    }
</script>

<script>
    
$(document).ready(function() {

    initializeInvoiceDatePicker();
    var  remainingBalance;

    $(document).on('submit', '#SaveCashReceiptForm', function (e) {
        e.preventDefault();
        showLoader();
        $("#SaveCashReceiptForm button[type=submit]").prop('disabled',true);
        $(".error").remove();
        $(".is-invalid").removeClass('is-invalid');

        // validation 
        var amount = parseFloat($("#amount").val());
        var original_amount = parseInt($("#original_amount").val()) || 0; 

        if (remainingBalance > 0)
        {
            hideLoader();
            $("#SaveCashReceiptForm button[type=submit]").prop('disabled', false);
            swal("Amount", "The amount entered must be less than the remaining balance.", "error");
            return;
        }

        var formData = $(this).serialize();
        var formAction = $(this).attr('action');

        var requestType = 'POST';
        @if(isset($cashManagement))
            requestType = 'PUT';
        @endif

        $.ajax({
            url: formAction,
            type: requestType,
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: formData,
            success: function (response) {
                hideLoader();
                var alertType = response['alert-type'];
                    var message = response['message'];
                    var title = "{{ trans('quickadmin.transaction-management.fields.case_reciept') }}";
                    $('#SaveCashReceiptForm')[0].reset(); 
                    swal({
                    title: response.invoiceNumber,
                    text: message,
                    icon: alertType,
                    buttons: {
                    confirm: 'OK',
                    },
                    closeOnClickOutside: false,
                    }).then((confirm) => {
                        if (confirm) {
                            window.location.replace(response.redirectUrl);
                        }
                    });                 
                                                                        
                    $("#SaveCashReceiptForm button[type=submit]").prop('disabled',false);
            },
            error: function (xhr) {
                hideLoader();
                $("#SaveCashReceiptForm button[type=submit]").prop('disabled',false);
                var errors= xhr.responseJSON.errors;
                for (const elementId in errors) {
                    //$("#"+elementId).addClass('is-invalid');
                    var errorHtml = '<div><span class="error text-danger">'+errors[elementId]+'</span></div>';
                    $(errorHtml).insertAfter($("#"+elementId).parent());
                }
            }
        });
    });
});
</script>