
<div class="row">

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="name">@lang('quickadmin.customers.fields.name')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="name" value="{{ isset($customer) ? $customer->name : old('name') }}" id="name" autocomplete="true" placeholder="Enter Name">
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6 fullselect2">
        <div class="form-group">
            <label for="area_id">@lang('quickadmin.customers.fields.area_address')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="area_id" class="form-control select2" id="area_id">
                    <option value="" disabled selected>@lang('quickadmin.customers.fields.select_address')</option>
                    @foreach($areas as $area)
                        <option value="{{ $area->id }}"  {{ isset($customer) ? $customer->area_id == $area->id ? 'selected' :'' :'' }} >{{ $area->address ??'' }} </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="phone_number">@lang('quickadmin.customers.fields.phone_number')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="phone_number" placeholder="Enter Phone Number" value="{{ isset($customer) ? $customer->phone_number : old('phone_number') }}" id="phone_number" autocomplete="true" maxlength="10" pattern="\d*" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);">                
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="alternate_phone_number">@lang('quickadmin.customers.fields.alternate_phone_number')</label>
            <div class="input-group">
                <input type="text" class="form-control" name="alternate_phone_number" placeholder="Enter Alternate Phone Number" value="{{ isset($customer) ? $customer->alternate_phone_number : old('alternate_phone_number') }}" id="alternate_phone_number" autocomplete="true" maxlength="10" pattern="\d*" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);">                
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="remark">@lang('quickadmin.customers.fields.remark')</label>
            <div class="input-group">
                <input type="text" class="form-control" name="remark" value="{{ isset($customer) ? $customer->remark : old('remark') }}" id="remark" autocomplete="true" placeholder="Enter Remark">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="credit_limit">@lang('quickadmin.customers.fields.credit_limit')</label>
            <div class="input-group">                            
                <input type="text" class="form-control" placeholder="Enter Credit Limit" name="credit_limit" value="{{ isset($customer) ? $customer->credit_limit : 0 }}" id="credit_limit" min="0" step=".01" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" >
            </div>
        </div>
    </div>

    <div class="col-md-12 text-right">
        <button type="submit" class="btn btn-primary">
        @if(isset($customer))
            @lang('quickadmin.qa_update')
        @else
            @lang('quickadmin.qa_submit')
        @endif
        </button>
    </div>
</div>




