
@extends('layouts.app')
@section('title')@lang('quickadmin.customer-management.fields.list') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">


<style>
    
</style>
@endsection
@section('main-content')

<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-nopwrap">{{ucwords($customer->name)}}</h4>
        <ul class="top_align_right">
            <li><x-svg-icon icon="phone" /> {{$customer->phone_number}}</li>
            <li><x-svg-icon icon="location" /> {{ $customer->area->address ?? '' }}</li>
        </ul>
    </div>
    <div class="card-body p-0">
        <div class="mx-0 mb-4 floatingLabel">
            <form action="" id="yearFilterForm">
                <div class="form-group">
                    <label for="year" class="select_year">@lang('quickadmin.customers.fields.select_year')</label>
                    <div class="selectyear d-flex align-items-center">
                        <select class="form-control" name="year" id="year" data-customerid={{$customer->uuid}}>
                            @foreach ($yearlist as $data)
                            <option value="{{ $data }}" {{ $year == $data ? 'selected' : '' }}>{{ $data }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </form>            
        </div>
        <div class="table-responsive fixed_Search">
            <table class="table custom_table table_Footer party_list_main">
                <thead>
                    <tr>
                        <th>@lang('quickadmin.customers.fields.particulars')</th>
                        <th>@lang('quickadmin.customers.fields.debit')</th>
                        <th>@lang('quickadmin.customers.fields.credit')</th>
                        <th>@lang('quickadmin.customers.fields.closing_blance')</th>
                        <th class="text-center">@lang('quickadmin.qa_action')</th>
                    </tr>
                    <tr>
                        <th colspan="3">@lang('quickadmin.customers.fields.opening_blance')</th>
                        <th colspan="2">₹ {{ number_format(abs($openingBalance), 2, '.', ',')}}{{ $openingBalance<=1 ? ' Cr' : ' Dr'}} </th>
                    </tr>
                </thead>
                <tbody>                    
                    @php
                        $totalSales = 0;
                        $totalCashReceipt = 0;                        
                        $lastClosingBalance = 0 ;
                    @endphp

                    @forelse($monthlyData as $index => $data)

                        @php
                            if($index === 0){
                                $monthlyClosingBalance = $lastClosingBalance + $data['sales'] + $openingBalance - ($data['cashreceipt']);
                            }
                            else{
                                $monthlyClosingBalance = $lastClosingBalance + $data['sales'] - ($data['cashreceipt']);
                            }

                            $monthlyClosingBalanceFormatted = $monthlyClosingBalance + $openingBalance;
                        @endphp

                        <tr>
                            <td>{{ \Carbon\Carbon::createFromFormat('Y-m', $data['month'])->format('F Y') }}</td>
                            <td>{{ number_format($data['sales'], 2, '.', ',') }}</td>
                            <td>{{ number_format($data['cashreceipt'], 2, '.', ',') }}</td>
                            <td>{{ number_format(abs($monthlyClosingBalanceFormatted), 2, '.', ',') }}{{ $monthlyClosingBalanceFormatted<=1 ? ' Cr' : ' Dr'}}</td>
                            <td>
                                <div>
                                    <a class="customer-month-detail" href="{{ route('customers.month.view', ['uuid' => $customer->uuid, 'month' => $data['month']]) }}">
                                        <x-svg-icon icon="view" />
                                    </a>                                                               
                                </div>
                            </td>
                        </tr>
                        @php
                            $totalSales += $data['sales'];
                            $totalCashReceipt += $data['cashreceipt'];
                            $lastClosingBalance = $monthlyClosingBalance;
                        @endphp

                    @empty
                        <tr>
                            <td colspan="5">No records found</td>
                        </tr>
                    @endforelse

                </tbody>
                <tfoot>
                    
                    <tr>
                        <th>Grand Total</th>
                        <th>₹ {{ number_format($totalSales, 2, '.', ',') }}</th>
                        <th>₹ {{ number_format($totalCashReceipt, 2, '.', ',') }}</th>
                        <th colspan="2">₹ {{ number_format($totalSales - ($totalCashReceipt) + $openingBalance , 2, '.', ',') }}</th>
                    </tr>
                </tfoot>          
            </table>
        </div>
    </div>
</div>

@endsection
@section('customJS')
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script>

$(document).ready(function (){

    $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).on('change','#yearFilterForm #year', function(e){
        e.preventDefault();
        var year = $(this).val();
        var customerId = $(this).attr('data-customerid');
        var hrefUrl = "{{ route('customers.monthly.show', ':uuid') }}".replace(':uuid', customerId) + '?year=' + year;
        window.location.href = hrefUrl;
    });
       
});
    
</script>
@endsection
