
@extends('layouts.app')
@section('title')@lang('quickadmin.customer-management.fields.list') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
<style>    
</style>
@endsection
@section('main-content')

<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-nopwrap">{{ $customer->name ? ucwords($customer->name) : "" }} ({{ \Carbon\Carbon::createFromFormat('Y-m', $month)->format('F Y') }})</h4>
        <div class="top_both_btn">
            @can('estimate_ledger_print')
                <a href="{{ route('customers.printPaymentHistory', ['actiontype' => "print-product-ledger", 'customer_id' => $customer->uuid, 'month' => $month]) }}" class="btn addRecordBtn addBtn" id="print-ledger-btn" data-value="print-product-ledger" title="Print Product Ledger"><x-svg-icon icon="print" />print product ledger</a>
            @endcan

            @can('estimate_statement_print')
            <a href="{{ route('customers.printPaymentHistory', ['actiontype' => "print-statement", 'customer_id' => $customer->uuid, 'month' => $month]) }}" class="btn addRecordBtn addBtn" id="print-statement-btn" data-value="print-statement" title="Print Statement" ><x-svg-icon icon="print" />print statement</a>
            @endcan           
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table_top-content">
            <div class="tTop-contentLeft">
                <a href="{{ route('customers.monthly.show',['uuid'=> $customer->uuid]) }}"> <x-svg-icon icon="backarrow" /> Back to List </a>
            </div>
            <div class="tTop-contentRight">
                <ul class="top_align_right">
                    <li><x-svg-icon icon="phone" /> {{$customer->phone_number}}</li>
                    <li><x-svg-icon icon="location" /> {{ $customer->area->address ?? '' }}</li>
                </ul>
            </div>
        </div>
        <div class="table-responsive fixed_Search">
            <table class="table custom_table table_Footer">                
                <thead>
                    <tr>
                        <th>@lang('quickadmin.customers.fields.invoice_date')</th>
                        <th>@lang('quickadmin.customers.fields.particulars')</th>
                        <th>@lang('quickadmin.customers.fields.invoice_number')</th>
                        <th>@lang('quickadmin.customers.fields.debit')</th>
                        <th>@lang('quickadmin.customers.fields.credit')</th>
                        <th>@lang('quickadmin.customers.fields.balance')</th>
                    </tr>
                    <tr>
                        <th colspan="3" class="text-right">@lang('quickadmin.customers.fields.opening_blance') </th>
                        <th colspan="3" class="text-left">₹ {{number_format($openingBalance, 2, '.', ',')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalSales = 0;
                        $totalCashReceipt = 0;
                        $lastBalance = (float)$openingBalance;
                    @endphp
                    
                    @foreach ($alldata as $data)
                        @php
                            $debitAmount = $data->type=='sales' ? $data->amount : 0;
                            $creditAmount = $data->type=='cashreceipt' ? $data->amount : 0;
                            $balance = $lastBalance + $debitAmount - $creditAmount;
                        @endphp
                        <tr>
                            <td>{{ $data->entry_date ? $data->entry_date->format('d-m-Y') : '' }}</td>
                            <td>
                                <button class="payment-detail-btn view_detail" data-url={{ $data->type=='cashreceipt' ? route('transactions.show', $data->uuid) : route('orders.show', $data->order?->uuid) }} >
                                    {{ $data->type=='sales' ? "Sales" : "Cash Receipt" }}
                                </button>
                            </td>
                            <td>{{ $data->voucher_number ?? ""}}</td>
                            <td>{!! $data->type == 'sales' ? '₹ ' . $data->amount : '' !!}</td>
                            <td>{!! $data->type=='cashreceipt' ? '₹ ' . $data->amount : "" !!}</td>
                            <td>{!! $balance ? '₹ ' . number_format(abs($balance), 2, '.', ',') : 0 !!}{{ $balance<=1 ? ' Cr' : ' Dr'}}</td>
                        </tr>
                        @php
                            if ($data->type == 'sales') {
                                $totalSales += $data->amount;
                            } elseif ($data->type == 'cashreceipt') {
                                $totalCashReceipt += $data->amount;
                            }

                            $lastBalance = $balance;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3" class="text-right">@lang('quickadmin.customers.fields.current_balance')</th>
                        <th><span>₹{{ number_format($totalSales, 2, '.', ',') }}</span></th>
                        <th colspan="2">₹{{ number_format($totalCashReceipt, 2, '.', ',') }}</th>
                    </tr>
                    @php
                        $grandTotal = number_format($totalSales + $openingBalance - ($totalCashReceipt), 2, '.', ',');
                    @endphp
                    <tr>
                        <th colspan="3" class="text-right">@lang('quickadmin.customers.fields.closing_blance')</th>
                        <th colspan="3" class="text-left"><span>₹{{ number_format($totalSales + $openingBalance - ($totalCashReceipt), 2, '.', ',') }}</span></th>
                    </tr>
                </tfoot>                
            </table>
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

@endsection
@section('customJS')
<script>
    $(document).ready(function(){
        $('#print-ledger-btn').printPage();
        $('#print-statement-btn').printPage();            

        $(document).on("click", ".view_detail", function (e) {
            e.preventDefault();
            var hrefUrl = $(this).attr('data-url');
            $.ajax({
                type: 'get',
                url: hrefUrl,                
                dataType: 'json',
                success: function (response) {
                    if(response.success) {
                        $('.popup_render_div').html(response.htmlView);
                        $('#viewModal').modal('show');
                        $('#order-detail-print').printPage(); 
                    }
                }
            });
        });    

    });
    
</script>
@endsection
