<div class="row">
    <div class="col-sm-6 col-md-6 fullselect2">
        <div class="form-group">
            <label for="product_id">@lang('quickadmin.inventory.fields.product_id')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="product_id" class="form-control select2" id="product_id">
                    <option value="" disabled selected>@lang('quickadmin.inventory.select_product')</option>
                    @foreach($allproduct as $product)
                        <option value="{{ $product->id }}"  {{ isset($inventory) ? $inventory->product_id == $product->id ? 'selected' :'' :'' }} >{{ $product->full_name ??'' }} </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="code">@lang('quickadmin.inventory.fields.quantity')<span class="text-danger">*</span></label>
            <div class="input-group">                            
                <input type="text" class="form-control" name="quantity" value="{{ isset($inventory) ? (int)$inventory->quantity : old('quantity') }}" id="quantity" min="1" step="1" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="@lang('quickadmin.qa_enter') @lang('quickadmin.inventory.fields.quantity')">
             </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="place">@lang('quickadmin.inventory.fields.area_id')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="place" class="form-control select2" id="place">
                    @foreach(config('app.product_place') as $key => $place)
                        <option value="{{$key }}"  {{ isset($inventory) ? $inventory->place == $key? 'selected' :'' :'' }} >{{ $place ??'' }} </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>  

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="entry_date">@lang('quickadmin.inventory.fields.entry_date')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="entry_date" max="<?= date('Y-m-d'); ?>" value="{{ isset($inventory) ? $inventory->entry_date : old('entry_date') }}" id="entry_date" >
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <div class="form-group">
            <label for="remark">@lang('quickadmin.inventory.fields.remark')</label>
            <div class="input-group">
                <input type="text" class="form-control" name="remark" value="{{ isset($inventory) ? $inventory->remark : old('remark') }}" id="remark" autocomplete="true" placeholder="Enter Remark">
            </div>
        </div>
    </div>

    <div class="col-md-12 text-right">
        <button type="submit" class="btn btn-primary">
        @if(isset($inventory))
            @lang('quickadmin.qa_update')
        @else
            @lang('quickadmin.qa_submit')
        @endif
        </button>
    </div>
</div>

