<div class="modal fade px-2" id="inventoryViewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle">@lang('quickadmin.inventory.view')</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label>@lang('quickadmin.inventory.select_product')</label>
                        <span class="text-capitalize">{{$shiftingGood->product->name ?? $inventory->product->name}}</span>
                    </li>
                    <li>
                        <label>@lang('quickadmin.inventory.fields.quantity')</label>
                        @if(isset($inventory))
                            <span>{{(int)$inventory->quantity}}</span>
                        @else
                            <span>{{(int)$shiftingGood->quantity}}</span>
                        @endif
                    </li>
                    @if(isset($inventory))
                        <li>
                            <label>@lang('quickadmin.inventory.fields.area_id')</label>
                            <span class="text-capitalize">{{ config('app.product_place.'.$inventory->place) ?? ''}}</span>
                        </li>
                    @else
                        <li>
                            <label>@lang('quickadmin.inventory.fields.from')</label>
                            <span class="text-capitalize">{{ config('app.product_place.'.$shiftingGood->from) ?? ''}}</span>
                        </li>
                        <li>
                            <label>@lang('quickadmin.inventory.fields.to')</label>
                            <span class="text-capitalize">{{ config('app.product_place.'.$shiftingGood->to) ?? ''}}</span>
                        </li>
                    @endif
                    <li>
                        <label>@lang('quickadmin.inventory.fields.entry_date')</label>
                        @if(isset($inventory))
                        <span>{{$inventory->entry_date ? $inventory->entry_date->format('d-m-Y') : ""}}</span>
                        @else
                        <span>{{$shiftingGood->entry_date ? $shiftingGood->entry_date->format('d-m-Y') : ""}}</span>
                        @endif
                    </li>
                    @if(isset($inventory) && !empty($inventory->remark))
                        <li>
                            <label>@lang('quickadmin.inventory.fields.remark')</label>
                            <span class="text-capitalize">{{ $inventory->remark ?? ''}}</span>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</div>
