
@extends('layouts.app')
@section('title')@lang('quickadmin.order-management.title')@endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">

@endsection

@section('main-content')

<div class="card MainBox">
    <div class="mainHeading">
        <h4>@lang('quickadmin.order-management.title')</h4>
        @can('estimate_date_filter_access')
        <div class="">
            <form id="invoice-filter-form">
                <div class="cart_filter_box">                                
                    @can('estimate_date_filter_access')
                    <div class="mx-0 datapikergroup custom-select2 floatingLabel">
                        <div class="form-control-inner form-group">
                            <label for="reportrange">@lang('quickadmin.order-management.select_date')</label>
                            <div id="reportrange" class="pull-right">
                                <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>&nbsp;
                                <span></span> <b class="caret"></b>
                            </div>
                        </div>
                    </div>
                    @endcan
                    <div class="form-group mb-0">
                        <button type="submit" class="btn addRecordBtn addBtn" id="apply-filter" title="@lang('quickadmin.qa_submit')"><i class="fa fa-paper-plane" aria-hidden="true"></i>
                            @lang('quickadmin.qa_submit')
                        </button>
                        <button type="reset" class="btn addRecordBtn addBtn" id="reset-filter" title="@lang('quickadmin.qa_reset')"><i class="fa fa-refresh" aria-hidden="true"></i>
                            @lang('quickadmin.qa_reset')
                        </button>
                    </div>                             
                </div>
            </form>
        </div>
        @endcan
    </div>
    <div class="card-body p-0">
        <div class="table-responsive fixed_Search">
            {{$dataTable->table(['class' => 'table dt-responsive invoicdatatable order_table_custom', 'style' => 'width:100%;','id'=>'dataaTable'])}}
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

@endsection


@section('customJS')
{!! $dataTable->scripts() !!}
    <script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
    <script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admintheme/assets/bundles/jquery-ui/jquery-ui.min.js') }}"></script>
    <!-- Page Specific JS File -->
    <script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
   
    <script type="text/javascript">
        $(function() {
            var date = '{{ config("app.start_date")}}';
            var start = moment(date, 'YYYY-MM-DD'); /*.moment().startOf('month')*/
            var end = moment();
            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

        });
        var defaultStartDate = moment('{{ config("app.start_date") }}', 'YYYY-MM-DD');
        var defaultEndDate = moment();

    </script>

<script>
    $(document).ready(function () {
        var dataTable = $('#dataaTable').DataTable();
        // $('#invoice-print').printPage();
        
        $(document).on('draw.dt','#dataaTable', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: 0
            }, 'fast');
        });      
        
        $(document).on("click", ".view-invoice-btn", function (e) {
            e.preventDefault();
            var hrefUrl = $(this).attr('data-href');
            $.ajax({
                type: 'get',
                url: hrefUrl,
                dataType: 'json',
                beforeSend: function () {
                  showLoader();
                },
                success: function (response) {
                    if(response.success) {
                        $('.popup_render_div').html(response.htmlView);
                        $('#viewModal').modal('show');
                        $('#order-detail-print').printPage(); 
                    }
                },
                complete: function () {
                  hideLoader();
                },
            });
        });

        $(document).on('click', '.delete-invoice-btn', function(e) {
            e.preventDefault();
            var hrefUrl = $(this).attr('data-href');
            swal({
                title: "{{ trans('messages.deletetitle') }}",
                text: "{{ trans('messages.areYouSure') }}",
                icon: 'warning',
                buttons: {
                confirm: "{{ trans('quickadmin.qa_delete') }}",
                cancel: "{{ trans('quickadmin.qa_cancel') }}",
                },
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                    url: hrefUrl,
                    type: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        var alertType = response['alert-type'];
                            var message = response['message'];
                            var title = response['title'];
                            showToaster(title,alertType,message);
                            dataTable.ajax.reload();
                    },
                    error: function (xhr) {
                        swal("{{ trans('quickadmin.order.invoice') }}", 'Something went wrong', 'error');
                    }
                    });
                }
            });
        }); 
       
        $('#reset-filter').on('click', function(e) {
            e.preventDefault();
            $('#invoice-filter-form')[0].reset();            

            //Reset the Daterangepicker
            if ($('#reportrange').data('daterangepicker')) {
                var start = defaultStartDate ?? null;
                var end = defaultEndDate ?? null;
                $('#reportrange').data('daterangepicker').setStartDate(start);
                $('#reportrange').data('daterangepicker').setEndDate(end);
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            var type = "{{$type}}";

            if(type == 'deleted'){
                var url = "{{ route('orders.index') }}/" + type;
                dataTable.ajax.url(url).load();
            }else{
                dataTable.ajax.url("{{ route('orders.index') }}").load();
            }

            originalPrintUrl = "{{ route('orders.allprint') }}";
            $('#invoice-print').attr('href', originalPrintUrl);
        });

        $('#invoice-filter-form').on('submit', function(e) {
            e.preventDefault();
           
            var picker = $('#reportrange').data('daterangepicker');           
            if (picker && picker.startDate && picker.endDate) {
                var from_date = picker.startDate.format('YYYY-MM-DD');
                var to_date = picker.endDate.format('YYYY-MM-DD');
            } else {               
                var from_date = null;
                var to_date = null;
            }

            var type = "{{$type}}";            

            if(from_date == undefined || from_date == 'Invalid date'){
                from_date = '';
            }

            if(to_date == undefined || to_date == 'Invalid date'){
                to_date = '';
            }           

            var printUrl = "{{ route('orders.allprint') }}"            
            + '?from_date=' + encodeURIComponent(from_date)
            + '&to_date=' + encodeURIComponent(to_date);

            var params = {
                    from_date        : from_date,
                    to_date          : to_date,
            };
            // Apply filters to the DataTable
            if(type == 'deleted'){
                dataTable.ajax.url("{{ route('orders.index') }}/" + type + "?" +$.param(params)).load();
            }else{
                dataTable.ajax.url("{{ route('orders.index') }}?"+$.param(params)).load();
            }

            $('#invoice-print').attr('href', printUrl);
        });

    });
</script>

@endsection
