<div class="row topRow2">
    @php
        $isCashCustomer = isset($transaction) && $transaction->customer && $transaction->customer->is_type === 'cash';
    @endphp
    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="voucher_number">@lang('quickadmin.transaction.fields.voucher_number')</label>
            <div class="input-group">
                <input type="text" class="form-control" name="voucher_number" 
                    value="{{ old($transaction->voucher_number ?? $invoice_number) }}" 
                    id="voucher_number" @if($isCashCustomer) readonly @endif placeholder="{{ $isCashCustomer ? 'Optional for cash customer' : 'Enter Estimate Number' }}">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="customer_id">@lang('quickadmin.transaction.fields.customer')<span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="customer_id" class="form-control select2" id="customer_id"
                    onchange="toggleVoucherField(this)">
                    <option value="" disabled selected>@lang('quickadmin.order.fields.select_customer')</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}" data-type="{{ $customer->customer_type }}"
                            {{ isset($transaction) ? $transaction->customer_id == $customer->id ? 'selected' :'' :'' }}
                            data-credit="{{ getTotalCredit($customer->id) }}" 
                            data-debit="{{ getTotalDebit($customer->id) }}" 
                            data-limit="{{$customer->credit_limit}}" >
                            {{ $customer->full_name ?? '' }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>


    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="remain_balance">@lang('quickadmin.transaction.fields.remain_balance')</label>
            <div class="input-group">
                <input type="text" placeholder="0.00" value="{{ isset($transaction) ? $remainingbalance : "0.00" }}"  id="remain_balance" data-original-remain-bal="{{ isset($transaction) ? ($remainingbalance + $transaction->amount) : "0.00" }}" class="form-control" name="remain_balance" tabindex="1"  readonly>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="entry_date">@lang('quickadmin.transaction.fields.entry-date')<span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="entry_date" max="<?= date('Y-m-d'); ?>" id="entry_date" >
            </div>
        </div>
    </div>

    <div class="col-lg-12">        
        <div class="form-group">
            <label for="remark">@lang('quickadmin.transaction.fields.remark')</label>
            <div class="input-group">
                <input type="text" placeholder="Enter Remark" id="remark" class="form-control" name="remark" value="{{ isset($transaction) ? $transaction->remark : old('remark') }}" tabindex="1">
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div id="paymentContainer">
            @if(isset($transaction) && $transaction->cashReceiptAmounts->count())
                @foreach($transaction->cashReceiptAmounts as $index => $row)
                    <div class="row paymentRow topRow2 mb-3">
                        <div class="col-sm-6col-md-4 col-lg-4">
                            <div class="form-group">
                                <label>@lang('quickadmin.transaction.fields.payment_mode')<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <select name="payment_way[]" class="form-control select2 payment_way">
                                        @foreach(config('constant.transactions.payment_ways') as $key => $value)
                                            <option value="{{ $key }}" {{ $row->payment_way == $key ? 'selected' : '' }}>
                                                {{ $value ?? '' }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" id="original_amount" value="{{ isset($transaction) ? $transaction->amount : "0.00" }}">

                        <div class="col-sm-6 col-md-4 col-lg-4">
                            <div class="form-group">
                                <label>@lang('quickadmin.transaction.fields.amount')<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form-control amount" name="amount[]" id="amount" min="1" step="1" value="{{ $row->amount }}" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="@lang('quickadmin.qa_enter') @lang('quickadmin.transaction.fields.amount')">
                                </div>
                                
                            </div>
                        </div>

                        <div class="col-md-2 col-lg-2 smright">
                            <button type="button" class="btn btn-success removePaymentBtn" {{ $index == 0 ? 'style=display:none' : '' }}>
                                <i class="fas fa-minus"></i>
                            </button>
                            @if($index == 0)
                                <button type="button" class="btn btn-success add_invoiceBtn" id="addPaymentBtn">
                                    <i class="fas fa-plus"></i>
                                </button>
                            @endif
                        </div>
                    </div>
                @endforeach
            @else
                {{-- fallback for creating new transaction --}}
                <div class="row paymentRow topRow2 mb-3">
                    <div class="col-sm-6 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label>@lang('quickadmin.transaction.fields.payment_mode')<span class="text-danger">*</span></label>
                            <div class="input-group">
                                <select name="payment_way[]" class="form-control select2 payment_way">
                                    @foreach(config('constant.transactions.payment_ways') as $key => $value)
                                        <option value="{{ $key }}">{{ $value ?? '' }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                            
                    <input type="hidden" id="original_amount" value="{{ isset($transaction) ? $transaction->amount : "0.00" }}">
                    <div class="col-sm-6 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label>@lang('quickadmin.transaction.fields.amount')<span class="text-danger">*</span></label>
                            <div class="input-group">
                               <input type="text" class="form-control amount" name="amount[]" id="amount" min="1" step="1" value="{{ isset($transaction) ? $transaction->amount : old('amount') }}" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="@lang('quickadmin.qa_enter') @lang('quickadmin.transaction.fields.amount')">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 col-lg-2 smright">
                        <button type="button" class="btn btn-success removePaymentBtn" style="display:none;">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-success add_invoiceBtn" id="addPaymentBtn" >
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            @endif
        </div>
    </div>
    <div class="col-12 col-xl-12">        
        <div class="">
            <button type="submit" class="btn btn-submit-block btn-lg btn-block ml-auto" title="@lang('quickadmin.qa_save')">@lang('quickadmin.qa_save')</button>
        </div>
    </div>
    
</div>

   
    
