@extends('layouts.app')
@section('title')@lang('admin_master.product.seo_title_product_master') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
@endsection
@section('main-content')

<div class="card MainBox">
  <div class="mainHeading">
    <h4>@lang('admin_master.product.seo_title_product_master')</h4>                 
    <div class="product_page_buttons">
        <div class="btn-column">
          <div class="in-btn-column">
            @can('product_create')                              
            <button type="button" class="btn addRecordBtn addBtn" title="@lang('admin_master.product.new_product')" data-href="{{ route('products.create')}}"><i class="fas fa-plus"></i>@lang('admin_master.product.new_product')</button>
            @endcan
          </div>
          <div class="in-btn-column">
            {{-- @can('product_export')
              <a href="{{ route('product.export')}}" class="excelbtn btn h-10 col circlebtn" title="@lang('messages.excel')"  id="excel-button"><x-svg-icon icon="excel" /></a>
            @endcan --}}
          </div>
        </div>
    </div>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive fixed_Search">
      {{$dataTable->table(['class' => 'table dt-responsive', 'style' => 'width:100%;'])}}
    </div>
  </div>
</div>
<div class="popup_render_div"></div>


  
<!-- view Modal -->
<div class="modal fade" id="view_model_Modal" tabindex="-1" role="dialog" aria-labelledby="view_model_ModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">@lang('admin_master.product.product_view') </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body show_html">
      </div>
    </div>
  </div>
</div>
<!-- view Modal -->
@include('admin.brand.add-brand')
@include('admin.unit_type.add-unit')
@endsection


@section('customJS')
{!! $dataTable->scripts() !!}
<script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>

<script type="text/javascript">
$(document).ready(function(){
    $(document).on('input', '.only_integer', function(evt) {
        var inputValue = $(this).val();
        $(this).val(inputValue.replace(/[^0-9.]/g, ''));
    });

  var DataaTable = $('#products-table').DataTable();
    $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).on('click','.view_detail',function(){
      $("#body").prepend('<div class="loader" id="loader_div"></div>');
      $("#view_model_Modal").modal('show');
      $('.show_html').html('');
      var _id = $(this).data('id');
      $("#exampleModalLongTitle").html($(this).data('product_name'));
      if(_id){
        var post_url = "{{ route('products.show',['product'=> ':viewId']) }}";
        post_url = post_url.replace(':viewId', _id);
        $.ajax({
              type: "GET",
              url: post_url,
              data: {id: _id},
              success: function(data) {
                  $("#loader_div").remove();
                  $('.show_html').html(data.html);
              },
              error: function () {
                $("#loader_div").remove();
              }
            });
         }
      });

    $(document).on('click','.delete_product',function(){       
      var delete_id = $(this).data('id');
      var delete_url = "{{ route('products.destroy',['product'=> ':productId']) }}";
          delete_url = delete_url.replace(':productId', delete_id);
      swal({
        title: "Are  you sure?",
        text: "{{ trans('messages.areYouSure') }}",
        icon: 'warning',
        buttons: {
          confirm: 'Yes, delete',
          cancel: 'No, cancel',
        },
        dangerMode: true,
        }).then(function(willDelete) {
        if(willDelete) {  
            $.ajax({
            type: "DELETE",
            url: delete_url,              
            success: function(data) {
              if ($.isEmptyObject(data.error)) {
                  DataaTable.ajax.reload();
                  var alertType = "{{ trans('quickadmin.alert-type.success') }}";
                  var message = "{{ trans('messages.crud.delete_record') }}";
                  var title = "Product";
                  showToaster(title,alertType,message); 
              } 
            },
                error: function (xhr) {
                  swal("{{ trans('quickadmin.order.invoice') }}", 'Something Went Wrong!', 'error');
                }
            });
          }
      })
    });

   

    // add product 
    $(document).on('click', '.addRecordBtn', function() {
            var hrefUrl = $(this).attr('data-href');
            $.ajax({
                type: 'get',
                url: hrefUrl,
                dataType: 'json',
                beforeSend: function () {
                  showLoader();
                },
                success: function(response) {
                    if (response.success) {
                        $('.popup_render_div').html(response.htmlView);
                        $('#centerModal').modal('show');
                        $('#brandList').select2({
                          dropdownParent: $('.popup_render_div #centerModal') // Set the dropdown parent to the modal
                        });

                        $('#unit_type').select2({
                          dropdownParent: $('.popup_render_div #centerModal') // Set the dropdown parent to the modal
                        });
                    }
                },
                complete: function () {
                  hideLoader();
                },
            });
        });  
        
      $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
      });

      $(document).on('click', ".save_product_btn", function(e) {
            e.preventDefault();
            if (e.keyCode == 13) {
                return false;
            }
            $('.error').html('');
            
            var action = $("#productFormMain").attr('action');
            var method = $("#productFormMain").attr('method');
            var formData = new FormData($("#productFormMain")[0]);
            $('.save_btn').prop('disabled', true);
            formData.append('_method', method);
            $.ajax({
                type: "POST",
                url: action,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                  showLoader();
                    if ($.isEmptyObject(data.error)) {
                        var alertType = "{{ trans('quickadmin.alert-type.success') }}";
                        var message = data.success;
                        var title = "Product";
                        showToaster(title, alertType, message);
                        $('#centerModal').modal('hide');
                        DataaTable.ajax.reload();                     
                    }else{
                        $('.save_product_btn').prop('disabled', false);
                        printErrorMsg(data.error);
                    }
                },
                complete: function () {
                  hideLoader();
                },
                error: function(data) {
                  hideLoader()
                  $('.save_product_btn').prop('disabled', false);
                }
            });
        });
        function printErrorMsg(msg) {
          $.each(msg, function(key, value) {
              $(`.error_${key}`).html(value);
          });
        }
    // add product 

    // edit
    $("body").on("click", ".edit-data-btn", function() {
            var hrefUrl = $(this).attr('data-href');
            $.ajax({
                type: 'get',
                url: hrefUrl,
                dataType: 'json',
                beforeSend: function () {
                  showLoader();
                },
                success: function(response) {
                    if (response.success) {
                        $('.popup_render_div').html(response.htmlView);
                        $('#centerModal').modal('show');

                        $('#brandList').select2({
                          dropdownParent: $('.popup_render_div #centerModal') // Set the dropdown parent to the modal
                        });

                        $('#unit_type').select2({
                          dropdownParent: $('.popup_render_div #centerModal') // Set the dropdown parent to the modal
                        });
                    }
                },
                complete: function () {
                  hideLoader();
                },
            });
        });
    // edit 



});
</script>

@include('admin/brand/_script')
@include('admin/unit_type/_script')
@endsection
