@extends('layouts.app')
@section('title')@lang('quickadmin.users.profile') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
@endsection

@section('main-content')

          <div class="card MainBox">
            <div class="mainHeading">
              <h2>Profile</h2>
            </div>
            <form id="EditProfileImageForm" method="post" enctype="multipart/form-data" action="{{route('profile-image.update')}}">
              <div class="author-box align-items-center " id="profile_error">
                <div class="rounded-circle author-box-picture shadow-none">
                    <img alt="image" src=" {{ $user->profile_image_url ? $user->profile_image_url : asset('admintheme/assets/img/user.png') }}" alt="profile" class="w-100 h-100 rounded-circle profile-image" >
                </div>
                <div class="page-inner text-left align-center">
                    <div class="profileName">{{ $user->name }}</div>
                    <div class="edit_profile"><label class="mb-0">@lang('quickadmin.profile.edit_profile') <input type="file" id="profile_image" name="profile_image"></label></div>
                </div>
              </div>
            </form>

            <div class="row persoanl_data">
              <div class="col-md-6 pr-lg-4">
                <div class="card-header" id="userhead">
                  <h4>@lang('quickadmin.profile.fields.personal_detail')</h4>
                  <a role="button" class="text-info" id="editButton" href="javascript:void(0);"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.4137 4.80283C17.4341 6.78244 12.7877 11.4279 11.6545 12.5574C11.4096 12.8013 11.1181 12.9941 10.8053 13.1198C9.89647 13.4969 7.67942 14.3666 7.02762 14.4104C6.63934 14.4364 6.2585 14.293 5.98288 14.0174C5.70726 13.7418 5.56387 13.361 5.58994 12.9727C5.6337 12.3209 6.50339 10.1057 6.87398 9.20061C7.00341 8.87937 7.19616 8.58792 7.44105 8.34396L15.1975 0.586619C15.5727 0.211369 16.083 0 16.6137 0C17.1445 0 17.6547 0.211369 18.03 0.586619L19.4137 1.9703C19.7889 2.34555 20.0003 2.85581 20.0003 3.38656C20.0003 3.91731 19.7889 4.42758 19.4137 4.80283ZM6.98945 13.0108C7.62635 12.9308 9.4877 12.1542 10.2699 11.8292C10.2727 11.8283 10.2754 11.8274 10.2773 11.8264C10.4235 11.7678 10.5557 11.6802 10.6665 11.5694L10.6675 11.5685C11.8025 10.439 16.4471 5.7945 18.4257 3.81489C18.5393 3.70129 18.6036 3.54765 18.6036 3.38656C18.6036 3.22548 18.5393 3.07184 18.4257 2.95824L17.0421 1.57456C16.9285 1.46096 16.7748 1.39671 16.6137 1.39671C16.4526 1.39671 16.299 1.46096 16.1854 1.57456L8.42806 9.33191C8.31632 9.44271 8.2288 9.57586 8.17013 9.72205L8.16827 9.72578C7.84703 10.5098 7.06952 12.373 6.98945 13.0108Z" fill="#DB5102"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5683 5.65973C17.8402 5.93255 17.8402 6.37485 17.5683 6.64767C17.2955 6.9205 16.8532 6.9205 16.5803 6.64767L13.3521 3.4194C13.0793 3.14658 13.0793 2.70428 13.3521 2.43146C13.6249 2.15957 14.0672 2.15957 14.34 2.43146L17.5683 5.65973Z" fill="#DB5102"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.8691 11.3592C12.1419 11.6311 12.1419 12.0743 11.8691 12.3462C11.5972 12.619 11.154 12.619 10.8821 12.3462L7.65384 9.1179C7.38101 8.846 7.38101 8.40278 7.65384 8.13089C7.92573 7.85806 8.36895 7.85806 8.64085 8.13089L11.8691 11.3592Z" fill="#DB5102"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M6.75078 1.84277C7.13627 1.84277 7.44914 2.15564 7.44914 2.54113C7.44914 2.92662 7.13627 3.23949 6.75078 3.23949H3.49178C2.33437 3.23949 1.39671 4.17715 1.39671 5.33456V16.5083C1.39671 17.0642 1.61739 17.5968 2.01034 17.9897C2.40328 18.3827 2.93589 18.6033 3.49178 18.6033H15.5966C16.1525 18.6033 16.6851 18.3827 17.0781 17.9897C17.471 17.5968 17.6917 17.0642 17.6917 16.5083V13.2493C17.6917 12.8638 18.0046 12.5509 18.3901 12.5509C18.7755 12.5509 19.0884 12.8638 19.0884 13.2493V16.5083C19.0884 17.4347 18.7206 18.3221 18.066 18.9776C17.4105 19.6322 16.5231 20 15.5966 20H3.49178C2.5653 20 1.67792 19.6322 1.02239 18.9776C0.367801 18.3221 0 17.4347 0 16.5083V5.33456C0 3.40616 1.56339 1.84277 3.49178 1.84277H6.75078Z" fill="#DB5102"/>
                    </svg></a>
                </div>
                <div class="card-body" id="userbody">
                  <div class="withoutEdit">
                    <p class="clearfix">
                      <span class="">
                        @lang('quickadmin.profile.fields.name')
                      </span>
                      <span class="text-muted">
                        {{ $user->name }}
                      </span>
                    </p>
                    <p class="clearfix">
                      <span class="">
                        @lang('quickadmin.profile.fields.usernameid')
                      </span>
                      <span class="text-muted">
                        {{ $user->username }}
                      </span>
                    </p>
                    <p class="clearfix">
                      <span class="">
                        @lang('quickadmin.profile.fields.email')
                      </span>
                      <span class="text-muted">
                        {{ $user->email }}
                      </span>
                    </p>
                    <p class="clearfix">
                      <span class="">
                        @lang('quickadmin.profile.fields.phone')
                      </span>
                      <span class="text-muted">
                        {{ $user->phone ?? '' }}
                      </span>
                    </p>                
                  </div>
                </div>
    
                <div class="card-header" id="edithead">
                    <h4>@lang('quickadmin.profile.edit_profile') </h4>
                </div>
                <div class="card-body floatingLabel" id="editbody">
                    <form method="POST" action="{{route('profile.update')}}" id="EditprofileForm">
                        @csrf
                          <div class="form-group">
                              <label for="name">@lang('quickadmin.profile.fields.name')</label>
                              <div class="input-group">
                                <input type="text" value="{{ old('name',$user->name) }}" id="name" class="form-control  @error('name') is-invalid @enderror" name="name" tabindex="1" placeholder="Enter Name"  autofocus>
                                @error('name')
                                <div class="invalid-feedback">
                                  {{ $message }}
                                </div>
                                @enderror
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="username">@lang('quickadmin.profile.fields.usernameid')</label>
                              <div class="input-group">
                                <input type="text" value="{{ old('username',$user->username) }}" id="username" class="form-control  @error('username') is-invalid @enderror" name="username" tabindex="1" placeholder="Enter Username"  autofocus>
                                @error('username')
                                <div class="invalid-feedback">
                                  {{ $message }}
                                </div>
                                @enderror
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="email">@lang('quickadmin.profile.fields.email')</label>
                              <div class="input-group">
                                <input type="email" value="{{ old('email',$user->email) }}" id="email" class="form-control @error('email') is-invalid @enderror" name="email" tabindex="1" placeholder="Enter Email"  autofocus>
                                @error('email')
                                <div class="invalid-feedback">
                                  {{ $message }}
                                </div>
                                @enderror
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="phone">@lang('quickadmin.profile.fields.phone')</label>
                              <div class="input-group">
                              <input type="text" value="{{ old('phone',$user->phone) }}" id="phone" class="form-control @error('phone') is-invalid @enderror" name="phone" tabindex="1" placeholder="Enter Number"  autofocus>
                              @error('phone')
                              <div class="invalid-feedback">
                                  {{ $message }}
                              </div>
                              @enderror
                              </div>
                          </div>
                          <div class="form-group mb-0 mt-4">
                            <button type="submit" class="btn btn-submit-block btn-block" tabindex="4">
                                @lang('quickadmin.qa_submit')
                            </button>
                          </div>
                    </form>
                </div>
              </div>

              <div class="col-md-6 pl-lg-4 mt-4 mt-md-0">
                      <div class="card-header">
                        <h4>@lang('quickadmin.qa_reset_password') </h4>
                      </div>
                      <div class="card-body floatingLabel">
                        <form method="POST" action="{{route('reset-password')}}" id="ChangePasswordForm">                          
                          <div class="form-group">
                            <label for="currentpassword">@lang('quickadmin.qa_current_password')</label>
                            <div class="input-group">
                              <input type="password" value="{{ old('currentpassword') }}" id="currentpassword" class="form-control  @error('currentpassword') is-invalid @enderror" name="currentpassword" placeholder="Enter Current Password" tabindex="1">
                              <span class="current-password-toggle-icon pass-toggle-icon"><i class="fas fa-eye-slash" onClick="ChangeEyeIcon($(this),'currentpassword');"></i></span>
                              @error('currentpassword')
                              <div class="invalid-feedback">
                                {{ $message }}
                              </div>
                              @enderror
                            </div>
                          </div>
                          <div class="form-group">
                            <label for="password">@lang('quickadmin.qa_new_password')</label>
                            <div class="input-group">
                              <input type="password" value="{{ old('password') }}" id="password" class="form-control  @error('password') is-invalid @enderror" name="password" placeholder="Enter New Password" tabindex="1">
                              <span class="password-toggle-icon pass-toggle-icon"><i class="fas fa-eye-slash" onClick="ChangeEyeIcon($(this),'password');"></i></span>
                              @error('password')
                              <div class="invalid-feedback">
                                {{ $message }}
                              </div>
                              @enderror
                            </div>
                          </div>
                          <div class="form-group">
                            <label for="password_confirmation">@lang('quickadmin.qa_confirm_password')</label>
                            <div class="input-group">
                              <input type="password" value="{{ old('password_confirmation') }}" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" placeholder="Enter Confirm Password" tabindex="1">
                              <span class="confirm-password-toggle-icon pass-toggle-icon"><i class="fas fa-eye-slash" onClick="ChangeEyeIcon($(this),'password_confirmation');"></i></span>
                              @error('password_confirmation')
                              <div class="invalid-feedback">
                                {{ $message }}
                              </div>
                              @enderror
                            </div>
                          </div>
        
                          <div class="form-group mb-0 mt-4">
                            <button type="submit" class="btn btn-submit-block btn-lg btn-block" tabindex="4">
                              <i class="fa fa-lock mr-1" aria-hidden="true"></i>
                              @lang('quickadmin.qa_change_password')
                            </button>
                          </div>
                        </form>
                      </div>
              </div>
            </div>            
          </div>



@endsection

@section('customJS')
<script>
$(document).ready(function() {
  $('#edithead, #editbody').hide();

  $('#profile_image').change(function(e) {
      e.preventDefault();
      $('#profile_error + div').empty().remove();
      var file = $(this).prop('files')[0];
      $(".error").remove();
      var selectedFile = this.files[0];
      var formData = new FormData($('#EditProfileImageForm')[0]);
      var formAction = $('#EditProfileImageForm').attr('action');
      $.ajax({
          url: formAction,
          type: 'POST',
          headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: formData,
          contentType: false,
          processData: false,
          success: function (response) {
                  var alertType = response['alert-type'];
                  var message = response['message'];
                  var title = response['title'];
                  showToaster(title,alertType,message);
                  $('#EditProfileImageForm')[0].reset();
                  location.reload();
          },
          error: function (xhr) {
              var errors= xhr.responseJSON.errors;
              var errorHtml = '<p class="error text-danger" style="line-height: 1;">';
              for (const elementId in errors) {
                  for (const error of errors[elementId]) {
                      errorHtml += error + '<br>';
                  }
              }
              errorHtml += '</p>';
              $(errorHtml).insertAfter($("#profile_error"));
          }
      });
  });

  $('#editButton').click(function() {
    $('#userhead').removeClass('d-flex');
    $('#userhead, #userbody').hide();
    $('#edithead, #editbody').show();
  });

  $('#EditprofileForm').on('submit', function (e) {
          e.preventDefault();

          $("#EditprofileForm button[type=submit]").prop('disabled',true);
          $(".error").remove();
          $(".is-invalid").removeClass('is-invalid');
          var formData = $(this).serialize();
          var formAction = $(this).attr('action');
          console.log(formAction);

          $.ajax({
              url: formAction,
              type: 'POST',
              headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
              data: formData,
              success: function (response) {
                      var alertType = response['alert-type'];
                      var message = response['message'];
                      var title = response['title'];
                      showToaster(title,alertType,message);
                      $('#EditprofileForm')[0].reset();
                      setTimeout(function() {
                          location.reload();
                      }, 2000);
              },
              error: function (xhr) {
                  var errors= xhr.responseJSON.errors;
                  console.log(xhr.responseJSON);

                  for (const elementId in errors) {
                      $("#EditprofileForm #"+elementId).addClass('is-invalid');
                      var errorHtml = '<div><span class="error text-danger">'+errors[elementId]+'</span></';
                      $(errorHtml).insertAfter($("#EditprofileForm #"+elementId).parent());
                  }
                  $("#EditprofileForm button[type=submit]").prop('disabled',false);
              }
          });
  });

  $(document).on('submit', '#ChangePasswordForm', function (e) {
      e.preventDefault();
      $("#ChangePasswordForm button[type=submit]").prop('disabled',true);
      $(".error").remove();
      var formData = $(this).serialize();
      var formAction = $(this).attr('action');
      $.ajax({
          url: formAction,
          type: 'POST',
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: formData,
          success: function (response) {
              $("#ChangePasswordForm button[type=submit]").prop('disabled',false);
              showToaster('Password','success',response['message']);
              $('#ChangePasswordForm')[0].reset();
          },
          error: function (xhr) {
              if(xhr.responseJSON.error_type == 'something_error'){
                  showToaster('Error','error',xhr.responseJSON.message);
              }else{
                  var errors= xhr.responseJSON.errors;
                  for (const elementId in errors) {
                      // $("#ChangePasswordForm #"+elementId).addClass('is-invalid');
                      var errorHtml = '<div><span class="error text-danger">'+errors[elementId]+'</span></';
                      $(errorHtml).insertAfter($("#ChangePasswordForm #"+elementId).parent());
                  }
              }
              $("#ChangePasswordForm button[type=submit]").prop('disabled',false);
          }
      });
    });

});

function ChangeEyeIcon(em,id) {
    em.toggleClass("fa-eye fa-eye-slash");
    var input = $("#"+id);
    if (input.attr("type") === "password") {
      input.attr("type", "text");
    } else {
      input.attr("type", "password");
    }
  }

</script>
@endsection
