
@extends('layouts.app')
@section('title')@lang('quickadmin.product_unint_master.title') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
<style>
    div#unitModal {
    z-index: 9999;
}
</style>
@endsection
@section('main-content')
<div class="card MainBox">
  <div class="mainHeading">
    <h4>@lang('quickadmin.product_unint_master.title')</h4>
    <div>
      @can('unit_create')
        <button type="button" class="btn addRecordBtn addBtn add_unit" title="@lang('quickadmin.product_unint_master.fields.new_unit')" ><i class="fas fa-plus"></i>@lang('quickadmin.product_unint_master.fields.new_unit')</button>
      @endcan
    </div>

  </div>
  <div class="card-body p-0">
    <div class="table-responsive fixed_Search unit-table">
      {{$dataTable->table(['class' => 'table dt-responsive', 'style' => 'width:100%;'])}}
    </div>
  </div>
</div>
@include('admin.unit_type.add-unit')

@endsection

@section('customJS')
{!! $dataTable->scripts() !!}
<script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>
<script type="text/javascript">
    // add or edit
    $(document).ready(function(){
        var DataaTable = $('#unit-table').DataTable();
        $(document).on('click','.edit_unit',function(){
            $('.error').html('');
            $("#unitModal").modal('show');
            $(".unit_edit_id").val($(this).data('id'));
            $(".unit_edit_name").val($(this).data('name'));
            $(".save_btn").html('Update');
            $(".Add_edit_unit").html('Edit');
        })
    
        $.ajaxSetup({
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        // add or edit
        // delete
        $(document).on('click','.delete_unit',function(){
            var delete_id = $(this).data('id');
            var delete_url = "{{ route('unit-type.destroy',['unit_type'=> ':unitId']) }}";
            delete_url = delete_url.replace(':unitId', delete_id);
            swal({
            title: "Are  you sure?",
            text: "{{ trans('messages.areYouSure') }}",
            icon: 'warning',
            buttons: {
              confirm: 'Yes, delete',
              cancel: 'No, cancel',
            },
            dangerMode: true,
            }).then(function(willDelete) {
            if(willDelete) {  
                $.ajax({
                type: "DELETE",
                url: delete_url,              
                success: function(data) {
                  if ($.isEmptyObject(data.error)) {
                    DataaTable.ajax.reload();
                    var alertType = "{{ trans('quickadmin.alert-type.success') }}";
                    var message = "{{ trans('messages.crud.delete_record') }}";
                    var title = "Unit";
                    showToaster(title,alertType,message);                    
                  } 
                },
                error: function (xhr) {
                  swal("{{ trans('quickadmin.order.invoice') }}", 'Something Went Wrong!', 'error');
                }
              });
            }

            })
        });
    })
</script>

@include('admin.unit_type._script')
@endsection
