
@switch($icon)
    @case('dashboard')
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
            <path d="M12.5926 2.2222C13.0017 2.2222 13.3333 1.89056 13.3333 1.48146C13.3333 1.07237 13.0017 0.740723 12.5926 0.740723H9.58499C7.77106 0.740713 6.34924 0.740713 5.22121 0.862925C4.07006 0.987646 3.13734 1.24672 2.34098 1.82532C1.85885 2.1756 1.43487 2.59958 1.08459 3.08169C0.505995 3.87807 0.246924 4.81079 0.122203 5.96194C-9.7575e-06 7.08997 -9.70132e-06 8.51178 1.75222e-07 10.3257V10.415C-9.70132e-06 12.2289 -9.7575e-06 13.6507 0.122203 14.7787C0.246924 15.93 0.505995 16.8626 1.08459 17.659C1.43487 18.1411 1.85885 18.5651 2.34097 18.9153C3.13734 19.494 4.07006 19.7531 5.22121 19.8778C6.34922 20 7.77106 20 9.58489 20H9.67437C11.4882 20 12.91 20 14.038 19.8778C15.1892 19.7531 16.1219 19.494 16.9183 18.9153C17.4004 18.5651 17.8244 18.1411 18.1746 17.659C18.7533 16.8626 19.0123 15.93 19.1371 14.7787C19.2593 13.6507 19.2593 12.2289 19.2593 10.4151V7.40739C19.2593 6.99829 18.9276 6.66665 18.5185 6.66665C18.1094 6.66665 17.7778 6.99829 17.7778 7.40739V10.3704C17.7778 12.2386 17.7768 13.5802 17.6642 14.6192C17.5531 15.6443 17.3406 16.2865 16.9761 16.7882C16.7172 17.1446 16.4039 17.458 16.0475 17.7168C15.5458 18.0814 14.9036 18.2938 13.8785 18.4049C12.8395 18.5175 11.4979 18.5185 9.62963 18.5185C7.76138 18.5185 6.41974 18.5175 5.38078 18.4049C4.35568 18.2938 3.7135 18.0814 3.21176 17.7168C2.85542 17.458 2.54204 17.1446 2.28314 16.7882C1.91861 16.2865 1.70612 15.6443 1.59506 14.6192C1.4825 13.5802 1.48148 12.2386 1.48148 10.3704C1.48148 8.5021 1.4825 7.16047 1.59506 6.12151C1.70612 5.09641 1.91861 4.45422 2.28314 3.95249C2.54204 3.59614 2.85542 3.28277 3.21176 3.02386C3.7135 2.65933 4.35568 2.44685 5.38079 2.33578C6.41974 2.22322 7.76138 2.2222 9.62963 2.2222H12.5926Z" fill="#E7F1FB"/>
            <path d="M4.02606 12.866C3.8459 13.2333 3.99759 13.6772 4.36488 13.8573C4.73217 14.0375 5.17597 13.8857 5.35614 13.5184L6.79845 10.5782C7.24549 9.66678 8.55945 9.71133 8.94374 10.6509C9.81209 12.7734 12.7804 12.8739 13.7904 10.815L15.2327 7.87475C15.4129 7.50745 15.2612 7.06364 14.8939 6.88349C14.5266 6.70332 14.0828 6.85501 13.9026 7.2223L12.4603 10.1626C12.0133 11.074 10.6993 11.0295 10.315 10.0899C9.44666 7.96741 6.47831 7.86685 5.46837 9.92575L4.02606 12.866Z" fill="#E7F1FB"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M15.0615 2.46914C15.0615 3.8328 16.167 4.93827 17.5307 4.93827C18.8943 4.93827 19.9998 3.8328 19.9998 2.46914C19.9998 1.10547 18.8943 0 17.5307 0C16.167 0 15.0615 1.10547 15.0615 2.46914ZM16.543 2.46914C16.543 3.0146 16.9852 3.45679 17.5307 3.45679C18.0761 3.45679 18.5183 3.0146 18.5183 2.46914C18.5183 1.92367 18.0761 1.48148 17.5307 1.48148C16.9852 1.48148 16.543 1.92367 16.543 2.46914Z" fill="#E7F1FB"/>
        </svg>
        @break
    @case('user')
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_212_3741)">
            <path d="M13.3692 11.6667H6.63083C5.53567 11.6681 4.48575 12.1037 3.71135 12.8781C2.93696 13.6525 2.50132 14.7024 2.5 15.7976V20.0001H17.5V15.7976C17.4987 14.7024 17.063 13.6525 16.2886 12.8781C15.5143 12.1037 14.4643 11.6681 13.3692 11.6667Z" fill="#B0B3B7"/>
            <path d="M10 10C12.7614 10 15 7.76142 15 5C15 2.23858 12.7614 0 10 0C7.23858 0 5 2.23858 5 5C5 7.76142 7.23858 10 10 10Z" fill="#B0B3B7"/>
            </g>
            <defs>
            <clipPath id="clip0_212_3741">
            <rect width="20" height="20" fill="white"/>
            </clipPath>
            </defs>
        </svg>
        @break
    @case('staff')
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
            <path d="M17.0837 18.1668C16.7503 18.1668 16.417 17.9168 16.417 17.5002C16.417 17.0835 16.667 16.8335 17.0837 16.8335C17.917 16.8335 18.5837 16.1668 18.5837 15.3335C18.5837 14.8335 18.5837 13.4168 15.7503 12.8335C15.417 12.7502 15.167 12.4168 15.2503 12.0835C15.3337 11.7502 15.667 11.5002 16.0003 11.5835C19.167 12.2502 19.8337 13.9168 19.8337 15.2502C19.8337 16.9168 18.5837 18.1668 17.0837 18.1668ZM12.0837 18.1668H2.91699C1.41699 18.1668 0.166992 16.9168 0.166992 15.4168C0.166992 14.2502 0.666992 12.6668 3.25033 11.9168C4.75033 11.5002 6.50033 11.5002 7.33366 11.5002H7.50033C8.41699 11.5002 10.0837 11.5002 11.5837 11.9168C14.167 12.6668 14.667 14.2502 14.667 15.4168C14.8337 16.9168 13.5837 18.1668 12.0837 18.1668ZM7.33366 12.7502C6.50033 12.7502 4.91699 12.7502 3.66699 13.1668C1.75033 13.7502 1.50033 14.7502 1.50033 15.5002C1.50033 16.3335 2.16699 17.0002 3.00033 17.0002H12.167C13.0003 17.0002 13.667 16.3335 13.667 15.5002C13.667 14.7502 13.417 13.7502 11.5003 13.1668C10.167 12.7502 8.58366 12.7502 7.75033 12.7502H7.41699C7.33366 12.7502 7.33366 12.7502 7.33366 12.7502ZM12.5003 9.8335C12.167 9.8335 11.8337 9.5835 11.8337 9.16683C11.8337 8.75016 12.0837 8.50016 12.5003 8.50016C14.0003 8.50016 15.2503 7.25016 15.2503 5.75016C15.2503 4.25016 14.0003 3.16683 12.5003 3.16683C12.167 3.16683 11.8337 2.91683 11.8337 2.50016C11.8337 2.0835 12.0837 1.8335 12.5003 1.8335C14.667 1.8335 16.5003 3.5835 16.5003 5.8335C16.5003 8.0835 14.667 9.8335 12.5003 9.8335ZM7.50033 9.8335C5.33366 9.8335 3.50033 8.0835 3.50033 5.8335C3.50033 3.5835 5.33366 1.91683 7.50033 1.91683C9.66699 1.91683 11.5003 3.66683 11.5003 5.91683C11.5003 8.16683 9.66699 9.8335 7.50033 9.8335ZM7.50033 3.16683C6.00033 3.16683 4.83366 4.3335 4.83366 5.8335C4.83366 7.3335 6.08366 8.5835 7.58366 8.5835C9.08366 8.5835 10.3337 7.3335 10.3337 5.8335C10.3337 4.3335 9.00033 3.16683 7.50033 3.16683Z" fill="#E7F1FB"/>
        </svg>
        @break
    @case('customer')
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_212_3171)">
            <path d="M7.5 10C4.7425 10 2.5 7.7575 2.5 5C2.5 2.2425 4.7425 0 7.5 0C10.2575 0 12.5 2.2425 12.5 5C12.5 7.7575 10.2575 10 7.5 10ZM18.9133 15.945L18.1017 15.4767C18.24 15.0625 18.3333 14.6275 18.3333 14.1667C18.3333 13.7058 18.2408 13.2708 18.1017 12.8567L18.9133 12.3883C19.3117 12.1583 19.4483 11.6483 19.2183 11.25C18.9875 10.8508 18.4792 10.7133 18.08 10.945L17.2692 11.4133C16.6817 10.7517 15.8992 10.2675 15 10.085V9.1675C15 8.7075 14.6267 8.33417 14.1667 8.33417C13.7067 8.33417 13.3333 8.7075 13.3333 9.1675V10.085C12.4342 10.2683 11.6517 10.7525 11.0642 11.4133L10.2533 10.945C9.85333 10.7142 9.345 10.8508 9.115 11.25C8.885 11.6492 9.02167 12.1583 9.42 12.3883L10.2317 12.8567C10.0933 13.2708 10 13.7058 10 14.1667C10 14.6275 10.0925 15.0625 10.2317 15.4767L9.42 15.945C9.02167 16.175 8.885 16.685 9.115 17.0833C9.27 17.3508 9.54917 17.5 9.8375 17.5C9.97833 17.5 10.1217 17.4642 10.2533 17.3883L11.0642 16.92C11.6517 17.5817 12.4342 18.0658 13.3333 18.2483V19.1658C13.3333 19.6258 13.7067 19.9992 14.1667 19.9992C14.6267 19.9992 15 19.6258 15 19.1658V18.2483C15.8992 18.065 16.6817 17.5808 17.2692 16.92L18.08 17.3883C18.2117 17.4642 18.355 17.5 18.4958 17.5C18.7842 17.5 19.0642 17.3508 19.2183 17.0833C19.4483 16.6842 19.3117 16.175 18.9133 15.945ZM14.1667 15.4167C13.4775 15.4167 12.9167 14.8558 12.9167 14.1667C12.9167 13.4775 13.4775 12.9167 14.1667 12.9167C14.8558 12.9167 15.4167 13.4775 15.4167 14.1667C15.4167 14.8558 14.8558 15.4167 14.1667 15.4167ZM6.66667 14.1667C6.66667 13.2967 6.8225 12.4642 7.095 11.6875C3.14833 11.8992 0 15.1683 0 19.1667C0 19.6267 0.373333 20 0.833333 20H9.4575C7.75667 18.625 6.66667 16.5242 6.66667 14.1667Z" fill="#B0B3B7"/>
            </g>
            <defs>
            <clipPath id="clip0_212_3171">
            <rect width="20" height="20" fill="white"/>
            </clipPath>
            </defs>
        </svg>
    @break
    @case('device')
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clip-path="url(#clip0_212_3173)">
        <path d="M17.5 5.83325C17.9583 5.83325 18.3333 5.45825 18.3333 4.99992C18.3333 2.69992 16.4667 0.833252 14.1667 0.833252H4.16667C1.86667 0.833252 0 2.69992 0 4.99992V10.8333C0 13.1333 1.86667 14.9999 4.16667 14.9999H8.33333V16.6666H5.83333C5.375 16.6666 5 17.0416 5 17.4999C5 17.9583 5.375 18.3333 5.83333 18.3333H9.16667C9.625 18.3333 10 17.9583 10 17.4999V10.8333C10 8.07492 12.2417 5.83325 15 5.83325H17.5ZM16.6667 7.49992H15C13.1583 7.49992 11.6667 8.99159 11.6667 10.8333V16.6666C11.6667 18.5083 13.1583 19.9999 15 19.9999H16.6667C18.5083 19.9999 20 18.5083 20 16.6666V10.8333C20 8.99159 18.5083 7.49992 16.6667 7.49992Z" fill="#B0B3B7"/>
        </g>
        <defs>
        <clipPath id="clip0_212_3173">
        <rect width="20" height="20" fill="white"/>
        </clipPath>
        </defs>
        </svg>
    @break
    @case('invoice')
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clip-path="url(#clip0_212_3177)">
        <path d="M11.6667 5.83333V0.383333C12.4276 0.671667 13.1276 1.11583 13.7209 1.70833L16.6242 4.61333C17.2176 5.20583 17.6617 5.90583 17.9501 6.66667H12.5001C12.0401 6.66667 11.6667 6.2925 11.6667 5.83333ZM12.9167 12.5H7.08341C6.85341 12.5 6.66675 12.6867 6.66675 12.9167V14.5833C6.66675 14.8133 6.85341 15 7.08341 15H12.9167C13.1467 15 13.3334 14.8133 13.3334 14.5833V12.9167C13.3334 12.6867 13.1467 12.5 12.9167 12.5ZM18.3334 8.7375V15.8333C18.3334 18.1308 16.4642 20 14.1667 20H5.83341C3.53591 20 1.66675 18.1308 1.66675 15.8333V4.16667C1.66675 1.86917 3.53591 0 5.83341 0H9.59592C9.73175 0 9.86592 0.0108333 10.0001 0.02V5.83333C10.0001 7.21167 11.1217 8.33333 12.5001 8.33333H18.3134C18.3226 8.4675 18.3334 8.60167 18.3334 8.7375ZM5.00008 5C5.00008 5.46 5.37341 5.83333 5.83341 5.83333H7.50008C7.96008 5.83333 8.33342 5.46 8.33342 5C8.33342 4.54 7.96008 4.16667 7.50008 4.16667H5.83341C5.37341 4.16667 5.00008 4.54 5.00008 5ZM5.00008 8.33333C5.00008 8.79333 5.37341 9.16667 5.83341 9.16667H7.50008C7.96008 9.16667 8.33342 8.79333 8.33342 8.33333C8.33342 7.87333 7.96008 7.5 7.50008 7.5H5.83341C5.37341 7.5 5.00008 7.87333 5.00008 8.33333ZM15.0001 12.9167C15.0001 11.7683 14.0651 10.8333 12.9167 10.8333H7.08341C5.93508 10.8333 5.00008 11.7683 5.00008 12.9167V14.5833C5.00008 15.7317 5.93508 16.6667 7.08341 16.6667H12.9167C14.0651 16.6667 15.0001 15.7317 15.0001 14.5833V12.9167Z" fill="#B0B3B7"/>
        </g>
        <defs>
        <clipPath id="clip0_212_3177">
        <rect width="20" height="20" fill="white"/>
        </clipPath>
        </defs>
        </svg>
    @break
    @case('report')
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="512" height="512" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M76 240c12.102 0 23.055-4.855 31.148-12.652l44.403 22.199c-.223 1.808-.551 3.586-.551 5.453 0 24.813 20.188 45 45 45s45-20.188 45-45c0-6.926-1.703-13.41-4.512-19.277l60.235-60.235C302.59 178.297 309.074 180 316 180c24.813 0 45-20.188 45-45 0-4.672-.918-9.09-2.246-13.328L411.09 82.43C418.23 87.2 426.79 90 436 90c24.813 0 45-20.188 45-45S460.812 0 436 0s-45 20.188-45 45c0 4.672.918 9.09 2.246 13.328L340.91 97.57C333.77 92.8 325.21 90 316 90c-24.813 0-45 20.188-45 45 0 6.926 1.703 13.41 4.512 19.277l-60.235 60.235C209.41 211.703 202.926 210 196 210c-12.102 0-23.055 4.855-31.148 12.652l-44.403-22.199c.223-1.808.551-3.586.551-5.453 0-24.813-20.187-45-45-45s-45 20.188-45 45 20.188 45 45 45zm0 0" fill="#000000" opacity="1" data-original="#000000"></path><path d="M497 482h-16V165c0-8.29-6.71-15-15-15h-60c-8.29 0-15 6.71-15 15v317h-30V255c0-8.29-6.71-15-15-15h-60c-8.29 0-15 6.71-15 15v227h-30V375c0-8.29-6.71-15-15-15h-60c-8.29 0-15 6.71-15 15v107h-30V315c0-8.29-6.71-15-15-15H46c-8.29 0-15 6.71-15 15v167H15c-8.29 0-15 6.71-15 15s6.71 15 15 15h482c8.29 0 15-6.71 15-15s-6.71-15-15-15zm0 0" fill="#000000" opacity="1" data-original="#000000"></path></g></svg>
    @break
    @case('modified')
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="512" height="512" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M292.545 325.52a45.258 45.258 0 0 1-17.589 10.871l-63.641 21.213a44.9 44.9 0 0 1-14.229 2.31h-.001c-12.021 0-23.321-4.681-31.82-13.181-12.131-12.134-16.295-29.778-10.87-46.051l21.214-63.638a45.208 45.208 0 0 1 10.87-17.59L323.934 82H55c-30.327 0-55 24.673-55 55v320c0 30.327 24.673 55 55 55h320c30.327 0 55-24.673 55-55V188.066z" fill="#000000" opacity="1" data-original="#000000" class=""></path><path d="M207.693 240.668a14.993 14.993 0 0 0-3.623 5.863l-21.214 63.639a15 15 0 0 0 18.973 18.973l63.64-21.213a14.986 14.986 0 0 0 5.863-3.623l187.384-187.383-63.639-63.639zM476.393 7.322c-9.763-9.763-25.592-9.763-35.355 0l-24.749 24.749 63.64 63.64 24.749-24.749c9.763-9.763 9.763-25.592 0-35.355z" fill="#000000" opacity="1" data-original="#000000" class=""></path></g></svg>
    @break
    @case('setting')
    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
        <path d="M16.5242 3.73947L10.8433 0.460238C9.78262 -0.153757 8.46239 -0.153068 7.40167 0.460238L1.72084 3.73947C0.659425 4.35277 0 5.49472 0 6.72064V13.2798C0 14.5057 0.659425 15.6477 1.72084 16.261L7.40167 19.5402C7.93237 19.8472 8.52778 20 9.1225 20C9.71722 20 10.3126 19.8465 10.8433 19.5402L16.5242 16.2603C17.5856 15.647 18.245 14.505 18.245 13.2791V6.71996C18.245 5.49403 17.5856 4.35208 16.5242 3.73878V3.73947ZM16.8683 13.2798C16.8683 14.0149 16.4725 14.7005 15.8358 15.0681L10.155 18.348C9.51761 18.7156 8.7274 18.7163 8.09 18.348L2.40917 15.0681C1.77246 14.7005 1.37667 14.0149 1.37667 13.2798V6.71996C1.37667 5.98481 1.77246 5.29923 2.40917 4.93166L8.09 1.65175C8.4087 1.46796 8.76526 1.37572 9.1225 1.37572C9.47975 1.37572 9.83631 1.46796 10.155 1.65175L15.8358 4.93166C16.4725 5.29923 16.8683 5.98481 16.8683 6.71996V13.2798Z" fill="#E7F1FB"/>
        <path d="M9.123 6.06543C6.95406 6.06543 5.18848 7.83032 5.18848 9.99995C5.18848 12.1696 6.95337 13.9345 9.123 13.9345C11.2926 13.9345 13.0575 12.1696 13.0575 9.99995C13.0575 7.83032 11.2926 6.06543 9.123 6.06543ZM9.123 12.5585C7.7126 12.5585 6.56515 11.411 6.56515 10.0006C6.56515 8.59024 7.7126 7.44279 9.123 7.44279C10.5334 7.44279 11.6809 8.59024 11.6809 10.0006C11.6809 11.411 10.5334 12.5585 9.123 12.5585Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('phone-book')
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M25 2H9a3.009 3.009 0 0 0-3 3v2.5H5a1 1 0 0 0 0 2h1v3H5a1 1 0 0 0 0 2h1v3H5a1 1 0 0 0 0 2h1v3H5a1 1 0 0 0 0 2h1V27a3.009 3.009 0 0 0 3 3h16a3.009 3.009 0 0 0 3-3V5a3.009 3.009 0 0 0-3-3zm-2.522 18.773a1.346 1.346 0 0 1-.818.894 3.336 3.336 0 0 1-1.153.2c-1.236 0-3.213-.61-5.613-3.515-3.339-4.032-2.505-6.42-1.991-7.259a1.347 1.347 0 0 1 1.155-.644 1.3 1.3 0 0 1 .973.43l1.056 1.278a1.937 1.937 0 0 1-.255 2.72.364.364 0 0 0-.112.307 3.11 3.11 0 0 0 .908 1.744c.919 1.109 1.459 1.229 1.648 1.229a.331.331 0 0 0 .217-.07 1.934 1.934 0 0 1 2.717.252l1.017 1.237a1.319 1.319 0 0 1 .251 1.197z" data-name="Layer 2" fill="#000000" opacity="1" data-original="#000000" class=""></path></g></svg>
    @break
    @case('backup')
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" width="612px" height="612px" viewBox="0 0 612 612" style="enable-background:new 0 0 612 612;" xml:space="preserve">
        <g>
            <g id="backup">
                <path d="M494.7,255C476.85,168.3,400.35,102,306,102c-73.95,0-137.7,40.8-168.3,102C58.65,214.2,0,277.95,0,357    c0,84.15,68.85,153,153,153h331.5c71.4,0,127.5-56.1,127.5-127.5C612,316.2,558.45,260.1,494.7,255z M357,331.5v102H255v-102    h-76.5L306,204l127.5,127.5H357z"/>
            </g>
        </g>
        </svg>
    @break
    @case('logout')
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.12305 9.6233C7.12305 9.22946 7.44233 8.91016 7.83619 8.91016H19.2856C19.6794 8.91016 19.9987 9.22946 19.9987 9.6233C19.9987 10.0172 19.6794 10.3365 19.2856 10.3365H7.83619C7.44233 10.3365 7.12305 10.0172 7.12305 9.6233Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.9969 6.34712C16.2748 6.06805 16.7263 6.06712 17.0054 6.34505L19.7895 9.11778C19.9239 9.25157 19.9995 9.43347 19.9995 9.62307C19.9995 9.81268 19.9239 9.99457 19.7895 10.1284L17.0054 12.9011C16.7263 13.179 16.2748 13.1781 15.9969 12.899C15.719 12.6199 15.7199 12.1684 15.9989 11.8905L18.2757 9.62307L15.9989 7.35566C15.7199 7.07773 15.719 6.6262 15.9969 6.34712Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.1516 2.3297C12.8901 2.87697 13.2593 3.77165 13.4112 5.41882C13.4473 5.81102 13.7946 6.09966 14.1867 6.0635C14.5789 6.02734 14.8675 5.6801 14.8314 5.28791C14.6695 3.53098 14.2447 2.10555 13.0007 1.18374C11.808 0.29996 10.0111 0 7.46523 0C4.08983 0 2.01453 0.529194 0.949495 2.263C0.441895 3.08936 0.217577 4.11277 0.10857 5.28432C-9.35861e-06 6.45128 -9.33313e-06 7.85318 1.75504e-07 9.47859V9.53868C-9.33313e-06 11.1641 -9.35861e-06 12.566 0.10857 13.7329C0.217577 14.9045 0.441895 15.9279 0.949495 16.7543C2.01453 18.4881 4.08983 19.0173 7.46523 19.0173C10.0111 19.0173 11.808 18.7173 13.0007 17.8335C14.2447 16.9117 14.6695 15.4863 14.8314 13.7293C14.8675 13.3372 14.5789 12.9899 14.1867 12.9538C13.7946 12.9176 13.4473 13.2063 13.4112 13.5985C13.2593 15.2456 12.8901 16.1403 12.1516 16.6876C11.3617 17.2729 9.9875 17.591 7.46523 17.591C4.08855 17.591 2.78781 17.0219 2.16481 16.0077C1.82842 15.4601 1.63073 14.697 1.52873 13.6008C1.42697 12.5072 1.4263 11.17 1.4263 9.50864C1.4263 7.84729 1.42697 6.51013 1.52873 5.41646C1.63073 4.3202 1.82842 3.55718 2.16481 3.00954C2.78781 1.99535 4.08855 1.4263 7.46523 1.4263C9.9875 1.4263 11.3617 1.74441 12.1516 2.3297Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('product')
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M1.43582 2.09311C1.91587 0.83286 3.12435 0 4.47293 0H15.5271C16.8757 0 18.0841 0.83285 18.5642 2.09311L19.7544 5.2176C19.9168 5.64392 20 6.09629 20 6.55249V15.2516C20 17.875 17.8734 20.0016 15.25 20.0016H4.75C2.12665 20.0016 0 17.875 0 15.2516V6.55249C0 6.09629 0.08324 5.64392 0.24563 5.2176L1.43582 2.09311ZM4.47293 1.5C3.74677 1.5 3.09605 1.94846 2.83756 2.62706L1.83826 5.25046H9.25V1.5H4.47293ZM10.75 1.5V5.25046H18.1617L17.1624 2.62706C16.9039 1.94846 16.2532 1.5 15.5271 1.5H10.75ZM18.5 6.75046H1.5V15.2516C1.5 17.0466 2.95507 18.5016 4.75 18.5016H15.25C17.0449 18.5016 18.5 17.0466 18.5 15.2516V6.75046ZM11.7168 15.0008C11.7168 14.5866 12.0526 14.2508 12.4668 14.2508H15.5332C15.9474 14.2508 16.2832 14.5866 16.2832 15.0008C16.2832 15.415 15.9474 15.7508 15.5332 15.7508H12.4668C12.0526 15.7508 11.7168 15.415 11.7168 15.0008Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('receipt')
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="16" viewBox="0 0 20 16" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M0 3.75C0 1.67893 1.67893 0 3.75 0H16.25C18.3211 0 20 1.67893 20 3.75V11.7492C20 13.8203 18.3211 15.4992 16.25 15.4992H3.75C1.67893 15.4992 0 13.8203 0 11.7492V3.75ZM3.75 1.5C2.50736 1.5 1.5 2.50736 1.5 3.75V11.7492C1.5 12.9919 2.50736 13.9992 3.75 13.9992H16.25C17.4926 13.9992 18.5 12.9919 18.5 11.7492V3.75C18.5 2.50736 17.4926 1.5 16.25 1.5H3.75ZM13.84 3.74957C13.84 3.33536 14.1758 2.99957 14.59 2.99957H15.9738C16.388 2.99957 16.7238 3.33536 16.7238 3.74957C16.7238 4.16378 16.388 4.49957 15.9738 4.49957H14.59C14.1758 4.49957 13.84 4.16378 13.84 3.74957ZM10 6.02823C9.0493 6.02823 8.2785 6.79893 8.2785 7.74963C8.2785 8.70043 9.0493 9.47113 10 9.47113C10.9507 9.47113 11.7215 8.70043 11.7215 7.74963C11.7215 6.79893 10.9507 6.02823 10 6.02823ZM6.77853 7.74963C6.77853 5.97053 8.2208 4.52819 10 4.52819C11.7792 4.52819 13.2215 5.97053 13.2215 7.74963C13.2215 9.52883 11.7792 10.9711 10 10.9711C8.2208 10.9711 6.77853 9.52883 6.77853 7.74963ZM3.27615 11.7497C3.27615 11.3354 3.61194 10.9997 4.02615 10.9997H5.41C5.82421 10.9997 6.16 11.3354 6.16 11.7497C6.16 12.1639 5.82421 12.4997 5.41 12.4997H4.02615C3.61194 12.4997 3.27615 12.1639 3.27615 11.7497Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('cashMmanagement')
    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
        <path d="M13.2434 18.2957C13.3752 18.4955 13.7766 18.7644 14.1934 18.4903C14.6868 18.1646 15.1512 17.7889 15.5734 17.3737C15.8434 17.1082 15.8473 16.6741 15.5816 16.4039C15.3162 16.1337 14.8821 16.1298 14.6118 16.3957C14.2523 16.7494 13.8573 17.0689 13.4375 17.3459C13.1218 17.5544 13.0348 17.9796 13.2434 18.2957Z" fill="#E7F1FB"/>
        <path d="M13.656 4.49207C14.0664 4.78344 14.4505 5.11639 14.7975 5.48117C14.9325 5.62298 15.3405 5.89003 15.7671 5.50548C16.0416 5.24435 16.0523 4.81048 15.7914 4.53594C15.3835 4.10707 14.9321 3.71594 14.4498 3.37367C14.141 3.15435 13.713 3.2273 13.4937 3.53594C13.2746 3.8448 13.3473 4.27298 13.656 4.49207Z" fill="#E7F1FB"/>
        <path d="M17.571 14.4562C17.8049 13.9118 17.986 13.3421 18.1097 12.763C18.1888 12.3927 17.9524 12.0282 17.5822 11.9493C17.2117 11.8702 16.8474 12.1066 16.7683 12.4768C16.6633 12.9687 16.5097 13.4523 16.311 13.9146C16.1615 14.2625 16.3058 14.8482 16.9408 14.8709C17.2063 14.8714 17.4592 14.7157 17.571 14.4562Z" fill="#E7F1FB"/>
        <path d="M18.1689 9.23047C18.0651 8.64683 17.9035 8.07138 17.688 7.51933C17.5505 7.16615 17.153 6.99206 16.8001 7.12956C16.4471 7.26706 16.2728 7.66456 16.4103 8.01752C16.593 8.48615 16.7303 8.97502 16.8185 9.4707C16.9119 10.3221 17.5732 10.033 17.6135 10.0257C17.9867 9.95933 18.2353 9.60342 18.1689 9.23047Z" fill="#E7F1FB"/>
        <path d="M9.15523 20C9.74909 20 10.3432 19.9427 10.9218 19.8295C11.2934 19.7568 11.5359 19.3966 11.4634 19.025C11.3907 18.6532 11.0307 18.4105 10.6589 18.4834C10.1668 18.5795 9.66114 18.6284 9.15523 18.6284C4.86295 18.6284 1.37114 15.1366 1.37114 10.8443C1.37114 7.38114 3.60773 4.39432 6.87205 3.40136C7.23159 4.34841 8.14523 5.02273 9.21818 5.02273C10.6052 5.02273 11.7298 3.89818 11.7298 2.51114C11.7298 1.12409 10.6057 0 9.21864 0C8.00409 0 6.99136 0.862045 6.75773 2.00727C2.7625 3.08432 0 6.67091 0 10.8445C0 15.893 4.10704 20 9.15523 20ZM9.21864 1.37159C9.84727 1.37159 10.3589 1.88318 10.3589 2.51182C10.3589 3.14045 9.84727 3.65205 9.21864 3.65205C8.59 3.65205 8.07864 3.14045 8.07864 2.51182C8.07864 1.88318 8.59 1.37159 9.21864 1.37159Z" fill="#E7F1FB"/>
        <path d="M9.21811 16.3653C9.59675 16.3653 9.9038 16.0585 9.9038 15.6797V14.8131C10.8845 14.6117 11.6243 13.7422 11.6243 12.7028C11.6243 11.5151 10.6581 10.5485 9.47016 10.5485H8.96584C8.53425 10.5485 8.18311 10.1974 8.18311 9.76579C8.18311 9.3342 8.53425 8.98306 8.96584 8.98306H10.6445C11.0231 8.98306 11.3302 8.67625 11.3302 8.29738C11.3302 7.91852 11.0231 7.61193 10.6445 7.61193H9.90334V6.62807C9.90334 6.24943 9.59652 5.94238 9.21766 5.94238C8.8388 5.94238 8.53198 6.2492 8.53198 6.62807V7.65579C7.5513 7.85716 6.81152 8.7267 6.81152 9.76602C6.81152 10.9537 7.77766 11.9201 8.96561 11.9201H9.46993C9.90152 11.9201 10.2527 12.2712 10.2527 12.7028C10.2527 13.1344 9.90152 13.4856 9.46993 13.4856H7.79107C7.41243 13.4856 7.10539 13.7924 7.10539 14.1712C7.10539 14.5499 7.41243 14.8569 7.79107 14.8569H8.53221V15.6799C8.53243 16.0585 8.83925 16.3653 9.21811 16.3653Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('cashBalance')
    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
        <path d="M13.2434 18.2957C13.3752 18.4955 13.7766 18.7644 14.1934 18.4903C14.6868 18.1646 15.1512 17.7889 15.5734 17.3737C15.8434 17.1082 15.8473 16.6741 15.5816 16.4039C15.3162 16.1337 14.8821 16.1298 14.6118 16.3957C14.2523 16.7494 13.8573 17.0689 13.4375 17.3459C13.1218 17.5544 13.0348 17.9796 13.2434 18.2957Z" fill="#E7F1FB"/>
        <path d="M13.656 4.49207C14.0664 4.78344 14.4505 5.11639 14.7975 5.48117C14.9325 5.62298 15.3405 5.89003 15.7671 5.50548C16.0416 5.24435 16.0523 4.81048 15.7914 4.53594C15.3835 4.10707 14.9321 3.71594 14.4498 3.37367C14.141 3.15435 13.713 3.2273 13.4937 3.53594C13.2746 3.8448 13.3473 4.27298 13.656 4.49207Z" fill="#E7F1FB"/>
        <path d="M17.571 14.4562C17.8049 13.9118 17.986 13.3421 18.1097 12.763C18.1888 12.3927 17.9524 12.0282 17.5822 11.9493C17.2117 11.8702 16.8474 12.1066 16.7683 12.4768C16.6633 12.9687 16.5097 13.4523 16.311 13.9146C16.1615 14.2625 16.3058 14.8482 16.9408 14.8709C17.2063 14.8714 17.4592 14.7157 17.571 14.4562Z" fill="#E7F1FB"/>
        <path d="M18.1689 9.23047C18.0651 8.64683 17.9035 8.07138 17.688 7.51933C17.5505 7.16615 17.153 6.99206 16.8001 7.12956C16.4471 7.26706 16.2728 7.66456 16.4103 8.01752C16.593 8.48615 16.7303 8.97502 16.8185 9.4707C16.9119 10.3221 17.5732 10.033 17.6135 10.0257C17.9867 9.95933 18.2353 9.60342 18.1689 9.23047Z" fill="#E7F1FB"/>
        <path d="M9.15523 20C9.74909 20 10.3432 19.9427 10.9218 19.8295C11.2934 19.7568 11.5359 19.3966 11.4634 19.025C11.3907 18.6532 11.0307 18.4105 10.6589 18.4834C10.1668 18.5795 9.66114 18.6284 9.15523 18.6284C4.86295 18.6284 1.37114 15.1366 1.37114 10.8443C1.37114 7.38114 3.60773 4.39432 6.87205 3.40136C7.23159 4.34841 8.14523 5.02273 9.21818 5.02273C10.6052 5.02273 11.7298 3.89818 11.7298 2.51114C11.7298 1.12409 10.6057 0 9.21864 0C8.00409 0 6.99136 0.862045 6.75773 2.00727C2.7625 3.08432 0 6.67091 0 10.8445C0 15.893 4.10704 20 9.15523 20ZM9.21864 1.37159C9.84727 1.37159 10.3589 1.88318 10.3589 2.51182C10.3589 3.14045 9.84727 3.65205 9.21864 3.65205C8.59 3.65205 8.07864 3.14045 8.07864 2.51182C8.07864 1.88318 8.59 1.37159 9.21864 1.37159Z" fill="#E7F1FB"/>
        <path d="M9.21811 16.3653C9.59675 16.3653 9.9038 16.0585 9.9038 15.6797V14.8131C10.8845 14.6117 11.6243 13.7422 11.6243 12.7028C11.6243 11.5151 10.6581 10.5485 9.47016 10.5485H8.96584C8.53425 10.5485 8.18311 10.1974 8.18311 9.76579C8.18311 9.3342 8.53425 8.98306 8.96584 8.98306H10.6445C11.0231 8.98306 11.3302 8.67625 11.3302 8.29738C11.3302 7.91852 11.0231 7.61193 10.6445 7.61193H9.90334V6.62807C9.90334 6.24943 9.59652 5.94238 9.21766 5.94238C8.8388 5.94238 8.53198 6.2492 8.53198 6.62807V7.65579C7.5513 7.85716 6.81152 8.7267 6.81152 9.76602C6.81152 10.9537 7.77766 11.9201 8.96561 11.9201H9.46993C9.90152 11.9201 10.2527 12.2712 10.2527 12.7028C10.2527 13.1344 9.90152 13.4856 9.46993 13.4856H7.79107C7.41243 13.4856 7.10539 13.7924 7.10539 14.1712C7.10539 14.5499 7.41243 14.8569 7.79107 14.8569H8.53221V15.6799C8.53243 16.0585 8.83925 16.3653 9.21811 16.3653Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('invoice2')
    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.15224 2.10328e-07H10.9941C12.2483 -9.54576e-06 13.2473 -1.92915e-05 14.0464 0.0839318C14.8679 0.170234 15.5592 0.351522 16.1649 0.768351C16.6652 1.11259 17.0913 1.55738 17.4191 2.07455C17.8131 2.69633 17.9843 3.4039 18.0662 4.25082C18.1464 5.07901 18.1464 6.11604 18.1464 7.42696V16.1982C18.1464 18.3775 15.7685 19.7955 13.9232 18.5134C13.5101 18.2264 12.9778 18.2264 12.5646 18.5134L11.5733 19.2021C11.5481 19.2196 11.5318 19.2309 11.5164 19.2414C10.0343 20.2529 8.11214 20.2529 6.62988 19.2414C6.61465 19.2311 6.59857 19.2199 6.57399 19.2028L5.58172 18.5134C5.16858 18.2264 4.63629 18.2264 4.22315 18.5134C2.37778 19.7955 2.11831e-07 18.3775 2.11831e-07 16.1982V7.42694C-9.54425e-06 6.11603 -9.61669e-06 5.079 0.0801074 4.25082C0.162029 3.40389 0.333258 2.69633 0.727258 2.07455C1.05496 1.55738 1.48112 1.11259 1.9814 0.768351C2.58716 0.351522 3.27838 0.170234 4.09993 0.0839318C4.8991 -1.92915e-05 5.89803 -9.54576e-06 7.15224 2.10328e-07ZM4.25282 1.53934C3.5526 1.6129 3.13447 1.75132 2.81095 1.97392C2.476 2.20442 2.18722 2.50463 1.96339 2.85785C1.74377 3.20443 1.60819 3.65288 1.53672 4.39173C1.46421 5.1412 1.46341 6.10746 1.46341 7.46563V16.1982C1.46341 17.3101 2.60565 17.8553 3.3882 17.3116C4.30335 16.6759 5.50153 16.6759 6.41667 17.3116L7.40531 17.9984L7.45467 18.0327C8.43945 18.7046 9.70687 18.7046 10.6916 18.0327L10.741 17.9984L11.7297 17.3116C12.6448 16.6759 13.843 16.6759 14.7581 17.3116C15.5407 17.8553 16.683 17.3101 16.683 16.1982V7.46563C16.683 6.10746 16.6821 5.1412 16.6096 4.39173C16.5382 3.65288 16.4026 3.20443 16.183 2.85785C15.9592 2.50463 15.6704 2.20442 15.3353 1.97392C15.0118 1.75132 14.5937 1.6129 13.8935 1.53934C13.1797 1.46436 12.2577 1.46341 10.9525 1.46341H7.1938C5.88863 1.46341 4.96661 1.46436 4.25282 1.53934ZM4.43901 6.15853C4.43901 5.75442 4.76661 5.42682 5.17072 5.42682H12.9755C13.3797 5.42682 13.7073 5.75442 13.7073 6.15853C13.7073 6.56264 13.3797 6.89024 12.9755 6.89024H5.17072C4.76661 6.89024 4.43901 6.56264 4.43901 6.15853ZM6.39023 9.93901C6.39023 9.53492 6.71783 9.20731 7.12193 9.20731H11.0243C11.4285 9.20731 11.756 9.53492 11.756 9.93901C11.756 10.3431 11.4285 10.6707 11.0243 10.6707H7.12193C6.71783 10.6707 6.39023 10.3431 6.39023 9.93901Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('customers')
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.53488 17.6868H1.5814C1.53209 17.6868 1.48465 17.6663 1.45023 17.6319C1.41488 17.5965 1.39535 17.55 1.39535 17.5007V16.1509C1.39535 15.3789 1.94698 14.6979 2.79721 14.1193C4.31535 13.083 6.77209 12.43 9.53488 12.43C9.92 12.43 10.2326 12.1175 10.2326 11.7323C10.2326 11.3482 9.92 11.0347 9.53488 11.0347C6.44465 11.0347 3.70884 11.8077 2.01023 12.9658C0.714419 13.8496 0 14.9723 0 16.1509V17.5007C0 17.9193 0.166512 18.3221 0.463256 18.6189C0.76 18.9147 1.16186 19.0821 1.5814 19.0821H9.53488C9.92 19.0812 10.2326 18.7686 10.2326 18.3835C10.2326 17.9993 9.92 17.6858 9.53488 17.6868Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.53522 0C6.71104 0 4.41895 2.29209 4.41895 5.11628C4.41895 7.94046 6.71104 10.2326 9.53522 10.2326C12.3594 10.2326 14.6515 7.94046 14.6515 5.11628C14.6515 2.29209 12.3594 0 9.53522 0ZM9.53522 1.39535C11.5892 1.39535 13.2562 3.06233 13.2562 5.11628C13.2562 7.17023 11.5892 8.83721 9.53522 8.83721C7.48127 8.83721 5.81429 7.17023 5.81429 5.11628C5.81429 3.06233 7.48127 1.39535 9.53522 1.39535Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1162 11.8027C13.2874 11.8027 11.8027 13.2874 11.8027 15.1162C11.8027 16.9451 13.2874 18.4306 15.1162 18.4306C16.9451 18.4306 18.4306 16.9451 18.4306 15.1162C18.4306 13.2874 16.9451 11.8027 15.1162 11.8027ZM15.1162 13.1981C16.1748 13.1981 17.0353 14.0576 17.0353 15.1162C17.0353 16.1748 16.1748 17.0353 15.1162 17.0353C14.0576 17.0353 13.1972 16.1748 13.1972 15.1162C13.1972 14.0576 14.0576 13.1981 15.1162 13.1981Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.8143 12.4994V10.9301C15.8143 10.545 15.5017 10.2324 15.1166 10.2324C14.7315 10.2324 14.4189 10.545 14.4189 10.9301V12.5003C14.4189 12.8845 14.7315 13.198 15.1166 13.198C15.5017 13.1971 15.8143 12.8845 15.8143 12.4994Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M17.4593 13.7601L18.569 12.6494C18.8416 12.3778 18.8416 11.935 18.569 11.6634C18.2974 11.3908 17.8546 11.3908 17.583 11.6634L16.4723 12.7732C16.2006 13.0457 16.2006 13.4876 16.4723 13.7601C16.7448 14.0318 17.1867 14.0318 17.4593 13.7601Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M17.7319 15.8138H19.3021C19.6873 15.8138 19.9998 15.5012 19.9998 15.1161C19.9998 14.731 19.6873 14.4185 19.3021 14.4185H17.7319C17.3477 14.4185 17.0352 14.731 17.0352 15.1161C17.0342 15.5012 17.3477 15.8138 17.7319 15.8138Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16.4723 17.4597L17.583 18.5695C17.8546 18.8421 18.2974 18.8421 18.569 18.5695C18.8416 18.2979 18.8416 17.8551 18.569 17.5835L17.4593 16.4728C17.1867 16.2011 16.7448 16.2011 16.4723 16.4728C16.2006 16.7453 16.2006 17.1872 16.4723 17.4597Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.4189 17.7323V19.3026C14.4189 19.6877 14.7315 20.0002 15.1166 20.0002C15.5017 20.0002 15.8143 19.6877 15.8143 19.3026V17.7323C15.8143 17.3482 15.5017 17.0356 15.1166 17.0347C14.7315 17.0347 14.4189 17.3482 14.4189 17.7323Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.7732 16.4728L11.6634 17.5835C11.3908 17.8551 11.3908 18.2979 11.6634 18.5695C11.935 18.8421 12.3778 18.8421 12.6494 18.5695L13.7601 17.4597C14.0318 17.1872 14.0318 16.7453 13.7601 16.4728C13.4876 16.2011 13.0457 16.2011 12.7732 16.4728Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.4994 14.4185H10.9301C10.545 14.4185 10.2324 14.731 10.2324 15.1161C10.2324 15.5012 10.545 15.8138 10.9301 15.8138H12.4994C12.8845 15.8138 13.198 15.5012 13.1971 15.1161C13.1971 14.731 12.8845 14.4185 12.4994 14.4185Z" fill="#E7F1FB"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.7601 12.7732L12.6494 11.6634C12.3778 11.3908 11.935 11.3908 11.6634 11.6634C11.3908 11.935 11.3908 12.3778 11.6634 12.6494L12.7732 13.7601C13.0457 14.0318 13.4876 14.0318 13.7601 13.7601C14.0318 13.4876 14.0318 13.0457 13.7601 12.7732Z" fill="#E7F1FB"/>
    </svg>
    @break
    @case('inventory')
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
        <path d="M11.1368 3.30979C11.1368 3.22282 11.1196 3.13672 11.0861 3.05645C11.0526 2.97618 11.0036 2.90334 10.9418 2.84213C10.88 2.78092 10.8067 2.73257 10.7261 2.69986C10.6456 2.66714 10.5593 2.65072 10.4723 2.65154H9.52842C9.43619 2.64259 9.3431 2.65304 9.25514 2.6822C9.16718 2.71137 9.0863 2.75861 9.01768 2.82089C8.94906 2.88317 8.89423 2.95912 8.85671 3.04385C8.81919 3.12858 8.7998 3.22023 8.7998 3.3129C8.7998 3.40557 8.81919 3.49721 8.85671 3.58194C8.89423 3.66667 8.94906 3.74262 9.01768 3.8049C9.0863 3.86718 9.16718 3.91443 9.25514 3.94359C9.3431 3.97276 9.43619 3.9832 9.52842 3.97425H10.4723C10.6486 3.97425 10.8176 3.90425 10.9422 3.77964C11.0668 3.65503 11.1368 3.48602 11.1368 3.30979Z" fill="#E7F1FB"/>
        <path d="M5.38643 11.9228H6.33655C6.50089 11.9069 6.65341 11.8303 6.76439 11.708C6.87537 11.5858 6.93684 11.4266 6.93684 11.2615C6.93684 11.0963 6.87537 10.9371 6.76439 10.8149C6.65341 10.6926 6.50089 10.616 6.33655 10.6001H5.38643C5.22208 10.616 5.06956 10.6926 4.95859 10.8149C4.84761 10.9371 4.78613 11.0963 4.78613 11.2615C4.78613 11.4266 4.84761 11.5858 4.95859 11.708C5.06956 11.8303 5.22208 11.9069 5.38643 11.9228Z" fill="#E7F1FB"/>
        <path d="M14.6139 10.6003H13.67C13.5778 10.5913 13.4847 10.6018 13.3967 10.6309C13.3088 10.6601 13.2279 10.7073 13.1593 10.7696C13.0907 10.8319 13.0358 10.9079 12.9983 10.9926C12.9608 11.0773 12.9414 11.169 12.9414 11.2616C12.9414 11.3543 12.9608 11.4459 12.9983 11.5307C13.0358 11.6154 13.0907 11.6914 13.1593 11.7536C13.2279 11.8159 13.3088 11.8632 13.3967 11.8923C13.4847 11.9215 13.5778 11.9319 13.67 11.923H14.6139C14.7062 11.9319 14.7993 11.9215 14.8872 11.8923C14.9752 11.8632 15.0561 11.8159 15.1247 11.7536C15.1933 11.6914 15.2481 11.6154 15.2856 11.5307C15.3232 11.4459 15.3425 11.3543 15.3425 11.2616C15.3425 11.169 15.3232 11.0773 15.2856 10.9926C15.2481 10.9079 15.1933 10.8319 15.1247 10.7696C15.0561 10.7073 14.9752 10.6601 14.8872 10.6309C14.7993 10.6018 14.7062 10.5913 14.6139 10.6003Z" fill="#E7F1FB"/>
        <path d="M19.2714 16.5618H18.9423V10.265C18.9406 9.73845 18.7307 9.23395 18.3584 8.86164C17.9861 8.48933 17.4816 8.27944 16.9551 8.27781H14.8003V1.98718C14.8011 1.72599 14.7502 1.46722 14.6507 1.22575C14.5511 0.984288 14.4047 0.764898 14.2201 0.580209C14.0354 0.39552 13.816 0.249178 13.5745 0.149604C13.333 0.0500295 13.0743 -0.000810299 12.8131 9.76492e-06H7.18692C6.65835 0.000627892 6.15153 0.2105 5.77727 0.58374C5.59321 0.768026 5.44742 0.986902 5.34831 1.22777C5.24919 1.46863 5.1987 1.72672 5.19975 1.98718V8.27781H3.04491C2.51877 8.28139 2.01497 8.49094 1.64147 8.86154C1.45602 9.0451 1.3089 9.26371 1.20869 9.50464C1.10848 9.74558 1.05717 10.004 1.05774 10.265V16.5618H0.72862C0.636384 16.5529 0.543297 16.5633 0.455338 16.5925C0.367379 16.6216 0.286493 16.6689 0.217876 16.7312C0.149258 16.7934 0.0944277 16.8694 0.0569057 16.9541C0.0193836 17.0389 0 17.1305 0 17.2232C0 17.3158 0.0193836 17.4075 0.0569057 17.4922C0.0944277 17.5769 0.149258 17.6529 0.217876 17.7152C0.286493 17.7775 0.367379 17.8247 0.455338 17.8539C0.543297 17.883 0.636384 17.8935 0.72862 17.8845H2.71579V19.2072C2.70684 19.2995 2.71728 19.3926 2.74645 19.4805C2.77561 19.5685 2.82285 19.6494 2.88514 19.718C2.94742 19.7866 3.02337 19.8414 3.1081 19.8789C3.19283 19.9165 3.28447 19.9358 3.37714 19.9358C3.46981 19.9358 3.56145 19.9165 3.64619 19.8789C3.73092 19.8414 3.80686 19.7866 3.86915 19.718C3.93143 19.6494 3.97867 19.5685 4.00784 19.4805C4.037 19.3926 4.04744 19.2995 4.0385 19.2072V17.8845H15.9615V19.2072C15.9526 19.2995 15.963 19.3926 15.9922 19.4805C16.0213 19.5685 16.0686 19.6494 16.1309 19.718C16.1931 19.7866 16.2691 19.8414 16.3538 19.8789C16.4385 19.9165 16.5302 19.9358 16.6229 19.9358C16.7155 19.9358 16.8072 19.9165 16.8919 19.8789C16.9766 19.8414 17.0526 19.7866 17.1149 19.718C17.1771 19.6494 17.2244 19.5685 17.2535 19.4805C17.2827 19.3926 17.2932 19.2995 17.2842 19.2072V17.8845H19.2714C19.3636 17.8935 19.4567 17.883 19.5447 17.8539C19.6326 17.8247 19.7135 17.7775 19.7821 17.7152C19.8507 17.6529 19.9056 17.5769 19.9431 17.4922C19.9806 17.4075 20 17.3158 20 17.2232C20 17.1305 19.9806 17.0389 19.9431 16.9541C19.9056 16.8694 19.8507 16.7934 19.7821 16.7312C19.7135 16.6689 19.6326 16.6216 19.5447 16.5925C19.4567 16.5633 19.3636 16.5529 19.2714 16.5618ZM6.52246 1.98718C6.52021 1.9004 6.53618 1.81412 6.56934 1.7339C6.6025 1.65368 6.65211 1.5813 6.71496 1.52143C6.84019 1.39595 7.00965 1.3246 7.18692 1.32272H12.8131C12.9904 1.3246 13.1598 1.39595 13.285 1.52143C13.3479 1.5813 13.3975 1.65368 13.4307 1.7339C13.4638 1.81412 13.4798 1.9004 13.4775 1.98718V8.27781H6.52246V1.98718ZM2.38045 10.265C2.38262 10.0896 2.45405 9.92216 2.57917 9.79923C2.63904 9.73637 2.71141 9.68677 2.79164 9.65361C2.87186 9.62045 2.95814 9.60448 3.04491 9.60672H9.33554V16.5618H2.38045V10.265ZM10.6645 16.5618V9.60672H16.9551C17.0419 9.60448 17.1281 9.62045 17.2084 9.65361C17.2886 9.68677 17.361 9.73637 17.4208 9.79923C17.5459 9.92216 17.6174 10.0896 17.6195 10.265V16.5618H10.6645Z" fill="#E7F1FB"/>
    </svg>
    @break
    <!-- Add more cases for additional icons -->
    @default
        <!-- Default case if no matching icon is provided -->
@endswitch



