<?php

use App\Http\Controllers\Admin\AreaController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Admin\InventoryController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\PaymentTransactionsController;
use App\Http\Controllers\Admin\CashManagementController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\UnitTypeController;
use App\Http\Controllers\Admin\CashBalanceController;
use App\Models\Inventory;
use Illuminate\Support\Facades\Artisan;

// Authentication Routes
Route::group(['middleware' => 'guest'], function () {
    Route::get('/', [LoginController::class, 'index'])->name('login');
    Route::post('/login', [LoginController::class, 'login'])->name('authenticate');
    Route::get('/forgot-password', [ForgotPasswordController::class, 'index'])->name('forgot.password');
    Route::post('/forgot-pass-mail', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password_mail_link');
    Route::get('reset-password/{token}/{email}', [ResetPasswordController::class, 'showform'])->name('resetPassword');
    Route::post('/reset-password', [ResetPasswordController::class, 'resetpass'])->name('reset-new-password');
});

Route::middleware(['auth', 'PreventBackHistory'])->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/logout', [LoginController::class, 'logout'])->name('logout');
    Route::resource('/roles', RoleController::class);
    Route::post('/user-status-change', [UserController::class, 'userStatusChange'])->name('user_status_change');
    Route::get('/profiles', [UserController::class, 'showprofile'])->name('user.profile');
    Route::post('/profile-update', [UserController::class, 'updateprofile'])->name('profile.update');
    Route::post('/profile-image', [UserController::class, 'updateprofileImage'])->name('profile-image.update');
    Route::post('/change-password', [UserController::class, 'updatePassword'])->name('reset-password');
    Route::resource('/staff', UserController::class);
    Route::get('/staff/password/{id}', [UserController::class, 'staffpassword'])->name('staff.password');
    Route::put('/staff/password/{id}', [UserController::class, 'staffUpdatePass'])->name('staff.change-password');
    Route::get('/staff-printView', [UserController::class, 'printView'])->name('staff.print');
    Route::get('staff-export/', [UserController::class, 'export'])->name('staff.export');
    Route::get('/staff/typeindex/{type?}', [UserController::class, 'typeindex'])->name('staff.typeindex');
    Route::patch('/staff/{staff}/rejoin', [UserController::class, 'rejoin'])->name('staff.rejoin');
    Route::get('/settings/{tab?}', [SettingController::class, 'index'])->name('settings');
    Route::post('/settings/update', [SettingController::class, 'update'])->name('settings.update');
    Route::resource('inventory',InventoryController::class,['parameters' => ['inventory' => 'inventory']]);
    Route::get('inventory-view',[InventoryController::class,'inventoryView'])->name('inventory_list.view');
    Route::get('inventory-detail/{id}/{place}',[InventoryController::class,'inventoryDetail'])->name('inventory_detail');
    Route::post('/inventory/shifting-goods', [InventoryController::class, 'storeShiftingGoods'])->name('inventory.shifting-goods.store');
    Route::get('shifting-good-show/{id}',[InventoryController::class,'shiftingGoodShow'])->name('shifting-good.show');
    Route::get('inventory-view/allprint', [InventoryController::class, 'allInventoryPrintView'])->name('inventory-view.allprint');

    Route::resource('areas',AreaController::class);
    Route::resource('brand',BrandController::class);
    Route::resource('unit-type',UnitTypeController::class);
    Route::resource('products',ProductController::class);
    Route::get('product-export/', [ProductController::class, 'export'])->name('product.export');
    Route::get('all-products',[ProductController::class,'allProducts'])->name('all-products');
    Route::resource('orders',OrderController::class);
    Route::get('orders/print/{order}',[OrderController::class,'printOrder'])->name('orders.print');
    Route::get('order/allprint',[OrderController::class,'allSelectedOrderPrint'])->name('orders.allprint');
    Route::get('order/allexport',[OrderController::class,'allSelectedOrderPrint'])->name('orders.allexport');
    Route::post('order/get-stock',[OrderController::class,'getStockAvailability'])->name('orders.getStockAvailability');
    Route::post('order/check-stock',[OrderController::class,'validateStockAvailability'])->name('orders.validateStockAvailability');

    Route::resource('transactions', PaymentTransactionsController::class);
    Route::get('customers/allprint',[CustomerController::class,'allCustomerPrintView'])->where('area_id', '.*')->name('customer.allprint');
    Route::get('customers/view-allmonth-detail/{uuid}', [CustomerController::class,'allMonthDetail'])->name('customers.monthly.show');
    Route::get('customer/view-customer-detail/{uuid}/{month}', [CustomerController::class, 'viewCustomerMonthDetail'])->name('customers.month.view');
    
    Route::get('customers/print-history',[CustomerController::class, 'printPaymentHistory'])->name('customers.printPaymentHistory');
    Route::resource('customers', CustomerController::class);
    Route::get('customers/mass-print-history', [CustomerController::class,'massPrintPaymentHistory'])->name('customers.massPrintPaymentHistory');
    
    

    Route::get('customers/mass-print-history', [CustomerController::class,'massPrintPaymentHistory'])->name('customers.massPrintPaymentHistory');   

    Route::get('/brand_to_category_get', [ProductController::class, 'getBrandToCategory'])->name('serch_to_product');
    
    Route::resource('cash-management', CashManagementController::class);

    Route::resource('cash-ledger', CashBalanceController::class);
    Route::post('get-cash-ledger-records', [CashBalanceController::class, 'cashLedgerRecords'])->name('getCashLedgerRecords');
    Route::get('view-cash-ledger', [CashBalanceController::class, 'viewCashLedgerDetail'])->name('cash-ledger.view');

});



Route::get('/phpinfo', function () {
    phpinfo();
});

Route::get('/refresh', function () {
    // Run Artisan commands
    Artisan::call('optimize:clear');
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return 'App refreshed successfully!';
});