<?php $__env->startSection('title'); ?><?php echo app('translator')->get('quickadmin.cash-balance.title'); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('customCss'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" >
<!-- Bootstrap Datepicker CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css" rel="stylesheet">
<style>

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-nopwrap"><?php echo app('translator')->get('quickadmin.cash-balance.title'); ?></h4>

        <div class="">
            <form id="cash-ledger-filter">
                <div class="cart_filter_box cart_filter_flex">
                    <div class="mx-0 datapikergroup custom-select2 floatingLabel">
                        <div class="form-control-inner form-group mb-0">
                            <label>Select Year</label>
                            <input type="text" class="form-control" id="yearPicker" placeholder="Select Year" autocomplete="off">
                        </div>
                    </div>
                    <div class="d-flex gap-3 form-group mb-0">
                        <button type="submit" class="btn addRecordBtn addBtn" id="apply-filter" title="<?php echo app('translator')->get('quickadmin.qa_submit'); ?>"><i class="fa fa-paper-plane" aria-hidden="true"></i>
                            <?php echo app('translator')->get('quickadmin.qa_submit'); ?>
                        </button>
                        <button type="reset" class="btn addRecordBtn addBtn" id="reset-filter" title="<?php echo app('translator')->get('quickadmin.qa_reset'); ?>"><i class="fa fa-refresh" aria-hidden="true"></i>
                            <?php echo app('translator')->get('quickadmin.qa_reset'); ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>

    </div>
    <div class="card-body p-0">
        <div class="table-responsive fixed_Search cash-ledger-table">
            <table class="table custom_table table_Footer ledger-table">
                <thead>
                    <tr>
                        
                        <th><?php echo app('translator')->get('quickadmin.cash-balance.fields.particulars'); ?></th>
                        <th><?php echo app('translator')->get('quickadmin.cash-balance.fields.debit'); ?></th>
                        <th><?php echo app('translator')->get('quickadmin.cash-balance.fields.credit'); ?></th>
                        <th><?php echo app('translator')->get('quickadmin.cash-balance.fields.balance'); ?></th>
                        <th><?php echo app('translator')->get('quickadmin.qa_action'); ?></th>
                    </tr>
                    <tr>
                        <th colspan="1" class="text-right"><?php echo app('translator')->get('quickadmin.cash-balance.fields.opening_balance'); ?> </th>
                        <th></th>
                        <th colspan="4" class="text-left">₹ <?php echo e(number_format($openingBalance, 2, '.', ',')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('customJS'); ?>
 <!-- Bootstrap Datepicker JS -->
 <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

 <script type="text/javascript">
    const currentDate = new Date();
    const currentMonth = (currentDate.getMonth() + 1).toString().padStart(2, '0'); // Months are 0-based
    const currentYear = currentDate.getFullYear();
    const filters = { month: currentMonth, year: currentYear };

    $('#yearPicker').datepicker({
        format: "yyyy",
        startView: "years",
        minViewMode: "years",
        autoclose: true,
        defaultViewDate: { year: currentYear },
        setDate: new Date(currentYear, 0, 1) // Set the default year
    }).datepicker('setDate', new Date(currentYear, 0, 1));


$(document).ready(function () {
    $('#reset-filter').on('click', function(e) {
        e.preventDefault();
        $('#cash-ledger-filter')[0].reset();
        $('#yearPicker').datepicker('update', `currentYear`);
        renderTable(filters);
    });

    $('#cash-ledger-filter').on('submit', function(e) {
        e.preventDefault();
        const year = $('#yearPicker').val();
        var params = {year};
        renderTable(params);
    });

    renderTable(filters);
});

async function renderTable(filters = '') {
    $('.loader').css('display','block');
    try {
        const hrefUrl = "<?php echo e(route('getCashLedgerRecords')); ?>";
        const response = await $.ajax({
            type: 'POST',
            url: hrefUrl,
            data: filters,
            dataType: 'json'
        });

        if (response.success) {
            $('.ledger-table tbody').remove();
            $('.ledger-table tfoot').remove();
            $('.ledger-table thead').after(response.htmlView);
            $('.loader').css('display','none');
        }
    } catch (error) {
        $('.loader').css('display','none');
        console.error("An error occurred:", error);
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/cash_balance/index.blade.php ENDPATH**/ ?>