
<div class="row">

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="name"><?php echo app('translator')->get('quickadmin.customers.fields.name'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="name" value="<?php echo e(isset($customer) ? $customer->name : old('name')); ?>" id="name" autocomplete="true" placeholder="Enter Name">
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6 fullselect2">
        <div class="form-group">
            <label for="area_id"><?php echo app('translator')->get('quickadmin.customers.fields.area_address'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="area_id" class="form-control select2" id="area_id">
                    <option value="" disabled selected><?php echo app('translator')->get('quickadmin.customers.fields.select_address'); ?></option>
                    <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($area->id); ?>"  <?php echo e(isset($customer) ? $customer->area_id == $area->id ? 'selected' :'' :''); ?> ><?php echo e($area->address ??''); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="phone_number"><?php echo app('translator')->get('quickadmin.customers.fields.phone_number'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="phone_number" placeholder="Enter Phone Number" value="<?php echo e(isset($customer) ? $customer->phone_number : old('phone_number')); ?>" id="phone_number" autocomplete="true" maxlength="10" pattern="\d*" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);">                
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="alternate_phone_number"><?php echo app('translator')->get('quickadmin.customers.fields.alternate_phone_number'); ?></label>
            <div class="input-group">
                <input type="text" class="form-control" name="alternate_phone_number" placeholder="Enter Alternate Phone Number" value="<?php echo e(isset($customer) ? $customer->alternate_phone_number : old('alternate_phone_number')); ?>" id="alternate_phone_number" autocomplete="true" maxlength="10" pattern="\d*" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);">                
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="remark"><?php echo app('translator')->get('quickadmin.customers.fields.remark'); ?></label>
            <div class="input-group">
                <input type="text" class="form-control" name="remark" value="<?php echo e(isset($customer) ? $customer->remark : old('remark')); ?>" id="remark" autocomplete="true" placeholder="Enter Remark">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="form-group">
            <label for="credit_limit"><?php echo app('translator')->get('quickadmin.customers.fields.credit_limit'); ?></label>
            <div class="input-group">                            
                <input type="text" class="form-control" placeholder="Enter Credit Limit" name="credit_limit" value="<?php echo e(isset($customer) ? $customer->credit_limit : 0); ?>" id="credit_limit" min="0" step=".01" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" >
            </div>
        </div>
    </div>

    <div class="col-md-12 text-right">
        <button type="submit" class="btn btn-primary">
        <?php if(isset($customer)): ?>
            <?php echo app('translator')->get('quickadmin.qa_update'); ?>
        <?php else: ?>
            <?php echo app('translator')->get('quickadmin.qa_submit'); ?>
        <?php endif; ?>
        </button>
    </div>
</div>




<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/customer/_form.blade.php ENDPATH**/ ?>