<?php $__env->startSection('title', 'Ledger Of '.$customer->name); ?>
<?php $__env->startSection('styles'); ?>
    <style>

		body{
            text-align:center;
            padding-top: 0px;
		}

        .table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
            margin-bottom: 5px;
            padding: 2px;
            padding-left:0;
            color: #000;
            padding-right:5px;
        }

        .table th {
            white-space: nowrap;
            color:#000;
            font-size: 11px;
            font-weight: bold;
        }
        .table th p{
            margin: 0px 0px 5px;
            line-height: 12px;
        }
        .table th .font-18{
            font-size: 18px;
        }
        .font-18{
            font-size: 18px;
        }
        .table tfoot tr td {
            color:#000 !important;
        }

        .table td {
            padding: 1px 1px 2px 14px;
            color:#000;
            font-size: 12px;
            vertical-align: middle;
        }

        .text-center {
            text-align: center;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }
        .font-800{
            font-weight: bold;
        }
        .padding-0{
            padding: 0;
        }

        .header-wrap tr th{
            padding-bottom:0;
        }
        .heading_wrap{
            padding:0;
            border:0.5px solid #333;
            border-left:0;
            border-right:0;
        }

        .heading_wrap thead th{
            padding: 8px 2px;
            border-bottom:1px solid #333;
            text-align:left;
        }

        .heading_wrap tbody td{
            font-size:14px;
            font-weight:400;
            color:#000000;
            padding: 8px 2px;
            text-align:left;
            vertical-align: text-top;
        }
        .w-50{
            white-space:normal;
            width:100px;
            min-width:50px;
        }
        .w-100{
            white-space:normal;
            width:200px;
        }
        .footer_tab ,.footer_tab tr, .footer_tab td{
            padding: 0;
            font-size:10px;
        }
        .footer_tab table{
            padding-top: 0;
            width:200px;
            margin-left:auto;
            margin-right:95px;
        }
        .footer_tab table tr{
            padding-top:0;
        }
        .footer_tab table td{
            font-weight:bold;
            font-size:9px;
        }
        .border-top {
            border-top:0.5px solid #000;
        }
        .border-top td, .space-wrap td{
            padding-top:5px;
        }
        .space-wrap td{
            padding-bottom:5px;
        }

        td.w-100 td {
            padding-left: 0 !important;
            padding-bottom:0 !important;
            margin-bottom:0;
            line-height:12px !important;
        }
        td.w-100 table{
            margin-bottom:0;
        }

        @page {
            margin: 10px 20px 10px;
        }
        .heading_wrap tr td,  .heading_wrap tr th{
            text-align: center;
            border:1px solid #000;
         }

         .data_type{
            padding-left:5px;
         }
         .main {
            margin-bottom:1rem;
         }
         .main p{
            margin:0;
         }
         .sm-font{
            font-size:14px;
         }
         .my-3{
            margin:2px 0 !important;
         }
        header{
            position: fixed;
            left: 0px;
            right: 0px;
            height: 200px;
            margin-top: -70px;
            margin-bottom:100px !important;
            padding-bottom: 20px !important;
            z-index: 1000;
        }

    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $debitTotal = 0;
        $creditTotal = 0;
        $balance = 0;
    ?>    

    <main>
    <table class="table table-wrapper heading_wrap" style="border:0px;margin-bottom:5px;">
        <thead>
            <tr style="border:0px;margin-top:15px;padding-top:15px;"><td colspan="4" style="border: 0px !important;margin-top:15px;padding-top:15px;"> &nbsp;</td></tr>
            <tr>
                <td colspan="7" style="border:0px;"><p class="font-18 font-800" style="margin: 0 0 3px;"><?php echo e(ucwords($customer->name)); ?></p><p class="sm-font my-3"><?php echo app('translator')->get('quickadmin.customers.fields.area_address'); ?> : <?php echo e($customer->area->address ?? ''); ?></p>
                    <p class="sm-font" style="margin: 0 0 3px;"><?php echo app('translator')->get('quickadmin.customers.fields.product_ledger'); ?></p><?php if(!is_null($from_date) && !is_null($to_date)): ?>
                    <p class="sm-font" style="margin: 0 0 3px;"><?php echo e(\Carbon\Carbon::parse($from_date)->format('d F Y')); ?> to <?php echo e(\Carbon\Carbon::parse($to_date)->format('d F Y')); ?></p>
                <?php endif; ?></td>
            </tr>
            <tr>
                <th colspan="4" style="font-size: 12px;"><?php echo app('translator')->get('quickadmin.customers.fields.particulars'); ?></th>
                <th style="font-size: 12px;"><?php echo app('translator')->get('quickadmin.customers.fields.debit'); ?></th>
                <th style="font-size: 12px;"><?php echo app('translator')->get('quickadmin.customers.fields.credit'); ?></th>
                <th style="font-size: 12px;"><?php echo app('translator')->get('quickadmin.customers.fields.balance'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if($customer->transaction->count() > 0 ): ?>
                <?php
                    $isOpeningBalance = true;
                    $balance += (float)$openingBalance;
                ?>

                <tr class="text-center">
                    <td colspan="4" style="text-align: center; font-size:14px;">
                        <strong> <?php echo app('translator')->get('quickadmin.customers.fields.opening_blance'); ?> </strong>
                    </td>
                    <td style="white-space: nowrap">
                        <span style="">&#x20B9;</span> <?php echo e(number_format(abs($openingBalance),0)); ?>

                    </td>
                    <td style="white-space: nowrap">
                        <strong> </strong>
                    </td>
                    <td style="white-space: nowrap">
                        <span style="">&#x20B9;</span> <?php echo e(number_format(abs($balance),0)); ?>

                        <?php echo e(($balance >= 0 ) ? 'Dr' : 'Cr'); ?>

                    </td>
                </tr>

                    <?php if($customer->transaction): ?>
                        <?php $__currentLoopData = $customer->transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                        
                            <?php if(!is_null($transaction->voucher_number) && $transaction->remark != 'Opening balance'): ?>
                                <?php
                                    $type = 'Cash Reciept';
                                    $voucherNumber = $transaction->voucher_number;
                                    $invoiceDate = date('d-m-Y',strtotime($transaction->entry_date));
                                    if($transaction->payment_way == 'order_create'){
                                        $type = 'Sales';
                                    }else if($transaction->payment_way == 'order_return'){
                                        $type = 'Sales Return';
                                    }
                                ?>
                                <tr>
                                    <td colspan="4" style="padding-top: 5px;padding-left:12px;padding-right:12px;">
                                        <div class="title text-left" style="padding-left: 5px;">
                                            <span style="padding-bottom:5px;display: block;">
                                                <?php if(!is_null($transaction->order)): ?>
                                                    <strong style="font-size:12px;">Type:</strong>
                                                <?php endif; ?>

                                                <?php if($isOpeningBalance == true && $transaction->remark == 'Opening balance' && in_array($transaction->payment_way,['by_cash','by_check','by_account'])): ?>
                                                    
                                                <?php else: ?>
                                                    <span style="padding-right: 8px;font-size:12px;"><?php echo e($type); ?></span>
                                                    <strong style="font-size:12px;">Vch.No:</strong>
                                                    <span style="padding-right: 8px;font-size:12px;"><?php echo e($voucherNumber); ?></span>
                                                    <strong style="font-size:12px;">Date:</strong>
                                                    <span style="padding-right: 8px;font-size:12px;"><?php echo e($invoiceDate); ?></span>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        <?php if(!is_null($transaction->order)): ?>
                                            <?php if($transaction->order->orderProduct()->count() > 0): ?>
                                            <table class="table data_type">
                                                <thead>
                                                    <tr><td style="padding: 5px;border:0px;"></td></tr>
                                                    <tr>
                                                        <td><?php echo app('translator')->get('quickadmin.qa_sn'); ?></td>
                                                        <td><?php echo app('translator')->get('quickadmin.inventory.fields.product_name'); ?></td>
                                                        <td><?php echo app('translator')->get('quickadmin.customers.fields.qty'); ?></td>
                                                        <td><?php echo app('translator')->get('quickadmin.qa_price'); ?></td>
                                                        <td><?php echo app('translator')->get('quickadmin.qa_amount'); ?></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $transaction->order->orderProduct()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <?php echo e(++$key); ?>

                                                        </td>
                                                        <td class="">
                                                            <?php echo e(ucfirst($item->product->full_name)); ?>                                                   
                                                        </td>
                                                        <td style="padding-left:5px;padding-right:5px;">
                                                            <?php echo e($item->quantity); ?>

                                                        </td>
                                                        <td style="white-space: nowrap">
                                                            <?php echo e(removeTrailingZeros($item->price)); ?>

                                                        </td>
                                                        <td style="white-space: nowrap">
                                                            <?php echo e(number_format(round($item->total_price),0)); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td style="white-space: nowrap;">
                                        <?php if($transaction->payment_type == 'debit'): ?>
                                            <?php
                                                $amount = (float)$transaction->amount;
                                                $debitTotal += $amount;
                                                $balance += round($amount);
                                            ?>
                                            <span style=""> &#x20B9;</span> <?php echo e(number_format(round($amount),0)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td style="white-space: nowrap;">
                                        <?php if($transaction->payment_type == 'credit'): ?>
                                        <span style=""> &#x20B9;</span> <?php echo e(number_format(round($transaction->amount),0)); ?>

                                            <?php
                                                $creditTotal += (float)$transaction->amount;
                                                $balance -= round((float)$transaction->amount);
                                            ?>
                                        <?php endif; ?>
                                    </td>
                                    <td style="white-space: nowrap;">
                                        <span style=""> &#x20B9;</span> <?php echo e(number_format(abs($balance),0)); ?>

                                        <?php echo e(($balance >= 0 ) ? 'Dr' : 'Cr'); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
            <?php endif; ?>
            
            <tr class="text-right">
                <td colspan="4" style="text-align: right; padding-right: 9px;">
                    <strong>Total</strong>
                </td>
                <td>
                    <?php if(isset($debitTotal) && $debitTotal > 0): ?>
                        <strong> <span style="">&#x20B9;</span> <?php echo e(number_format($debitTotal,0)); ?></strong>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($creditTotal) && $creditTotal > 0): ?>
                        <strong> <span style="">&#x20B9;</span> <?php echo e(number_format($creditTotal,0)); ?></strong>
                    <?php endif; ?>
                </td>
                <td></td>
            </tr>
            <tr class="text-right">
                <td colspan="4" style="text-align: right; padding-right: 9px;">
                    <strong> <?php echo app('translator')->get('quickadmin.customers.fields.closing_blance'); ?> </strong>
                </td>
                <td>
                    <?php
                        $closingBalance = ((float)$debitTotal+(float)$openingBalance) - (float)$creditTotal;
                    ?>
                    <strong> <span style="">&#x20B9;</span> <?php echo e(number_format(abs($closingBalance),0)); ?> <?php echo e(($closingBalance >= 0 ) ? 'Dr' : 'Cr'); ?> </strong>
                </td>
                
                <td>
                    <strong> </strong>
                </td>
                <td></td>
            </tr>
        </tbody>
        <tfoot>
           <tr style="padding-top:0px;margin-top:0px;border:0px;"><td colspan="4" style="border: 0px !important;"></td></tr>
           <tr style="padding-top:0px;margin-top:0px;border:0px;"><td colspan="4" style="border: 0px !important;"></td></tr>
           <tr style="padding-top:0px;margin-top:0px;border:0px;"><td colspan="4" style="border: 0px !important;"></td></tr>
           <tr style="padding-top:0px;margin-top:0px;border:0px;"><td colspan="4" style="border: 0px !important;"></td></tr>
        </tfoot>
    </table>
    </main>

    <footer>
        <table style="padding-left:8px;">
            <tr>
                <td style="margin: 0px; font-size:12px;" class="font-bold">
                <p>
                    <h4 style="margin:1px 0 0">THANK YOU</h4>
                </p>
                </td>
            </tr>
        </table>
    </footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.exports.pdf.layout.pdf', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/exports/pdf/ledger_print.blade.php ENDPATH**/ ?>