<?php
  $isSuperAdmin = auth()->user()->hasRole(config('app.roleid.super_admin'));    
?>

<div class="row topRow2">

    <?php if($isSuperAdmin): ?>
    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="voucher_number"><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></label>
            <div class="input-group">
                <input type="text" class="form-control" name="voucher_number" value="<?php echo e(isset($cashManagement) ? $cashManagement->voucher_number : $invoice_number); ?>" id="voucher_number" readonly>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="user_id"><?php echo app('translator')->get('quickadmin.cash-management.fields.staff'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="user_id" class="form-control select2" id="user_id">
                    <option value="" disabled selected><?php echo app('translator')->get('quickadmin.cash-management.fields.select'); ?></option>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($customer->id); ?>"  <?php echo e(isset($cashManagement) ? $cashManagement->user_id == $customer->id ? 'selected' :'' :''); ?> ><?php echo e($customer->name ??''); ?> <?php echo e($customer->phone?' - '. $customer->phone:''); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                
            </div>
        </div>
    </div>  

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="payment_way"><?php echo app('translator')->get('quickadmin.transaction.fields.payment_mode'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="payment_way" class="form-control select2" id="payment_way">
                    <?php $__currentLoopData = config('constant.payment_ways'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"  <?php echo e(isset($cashManagement) ? $cashManagement->payment_way == $key ? 'selected' :'' :''); ?> ><?php echo e($value ?? ''); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

    <?php else: ?>

    <input type="hidden" name="voucher_number" value="<?php echo e(isset($cashManagement) ? $cashManagement->voucher_number : $invoice_number); ?>" id="voucher_number">
    <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">
    <input type="hidden" name="payment_way" value="by_cash">

    <?php endif; ?>


    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="amount"><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="amount" id="amount" min="1" step="1" value="<?php echo e(isset($cashManagement) ? $cashManagement->amount : old('amount')); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="<?php echo app('translator')->get('quickadmin.qa_enter'); ?> <?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?>">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="form-group">
            <label for="entry_date"><?php echo app('translator')->get('quickadmin.transaction.fields.entry-date'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="entry_date" max="<?= date('Y-m-d'); ?>" id="entry_date" >
            </div>
        </div>
    </div>

    <div class="col-md-12 col-lg-12">        
        <div class="form-group">
            <label for="remark"><?php echo app('translator')->get('quickadmin.transaction.fields.remark'); ?></label>
            <div class="input-group">
                <input type="text" placeholder="Enter Remark" id="remark" class="form-control" name="remark" value="<?php echo e(isset($cashManagement) ? $cashManagement->remark : old('remark')); ?>" tabindex="1">
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl-12">        
        <div class="">
            <button type="submit" class="btn btn-submit-block btn-lg btn-block ml-auto" title="<?php echo app('translator')->get('quickadmin.qa_save'); ?>"><?php echo app('translator')->get('quickadmin.qa_save'); ?></button>
        </div>
    </div>
    
</div>

   
    
<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/cash_management/_form.blade.php ENDPATH**/ ?>