<form action="<?php echo e(route('settings.update')); ?>" method="POST" id="settingform" enctype="multipart/form-data">
    <div class="row">
        <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-6 floatingLabel">
            <div class="form-group mb-4">
                <label for="<?php echo e($setting->key); ?>"><?php echo e($setting->display_name); ?></label>
                <?php if($setting->type === 'image'): ?>
                    <input type="file" class="form-control" name="<?php echo e($setting->key); ?>" value="<?php echo e(isset($settings) ? $setting->value : old($setting->value)); ?>" id="<?php echo e($setting->key); ?>" autocomplete="true">

                <?php elseif($setting->type === 'password'): ?>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                        <i class="fas fa-lock"></i>
                        </div>
                    </div>
                    <input type="password" class="form-control passwordh_42" name="<?php echo e($setting->key); ?>" value="<?php echo e(isset($settings) ? decrypt($setting->value) : old($setting->key)); ?>" id="<?php echo e($setting->key); ?>" >
                    <span class="current-password-toggle-icon pass-toggle-icon"><i class="fas fa-eye" onClick="ChangeEyeIcon($(this),'<?php echo e($setting->key); ?>');"></i></span>
                </div>

                <?php elseif($setting->type === 'number'): ?>
                    <input type="number" class="form-control" name="<?php echo e($setting->key); ?>" value="<?php echo e(isset($settings) ? $setting->value : old($setting->value)); ?>" id="<?php echo e($setting->key); ?>" autocomplete="true">

                <?php elseif($setting->type === 'text'): ?>
                    <input type="text" class="form-control" name="<?php echo e($setting->key); ?>" value="<?php echo e(isset($settings) ? $setting->value : old($setting->value)); ?>" id="<?php echo e($setting->key); ?>" autocomplete="true" placeholder="Enter <?php echo e($setting->display_name); ?>">
                <?php elseif($setting->type == 'text_area'): ?>
                    <?php if($setting->details): ?>
                        <?php
                        $parameterArray = explode(', ',$setting->details);
                        ?>
                        <?php if($parameterArray): ?>
                            <?php $__currentLoopData = $parameterArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" class="btn btn-sm btn-info copy-btn mb-1 p-1 font-weight-bold" data-elementVal="<?php echo e($parameter); ?>" data-targetTextareaId="<?php echo e($setting->key); ?>"><?php echo e($parameter); ?></button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                    <textarea class="summernote" id="<?php echo e($setting->key); ?>" data-elementName ="<?php echo e($setting->key); ?>" placeholder="<?php echo e($setting->display_name); ?>" name="<?php echo e($setting->key); ?>" rows="4"><?php echo e($setting->value); ?></textarea>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-12 text-right">
            <button type="submit" class="btn btn-primary" title="<?php echo app('translator')->get('quickadmin.qa_submit'); ?>"><?php echo app('translator')->get('quickadmin.qa_submit'); ?></button>
        </div>
    </div>
</form>

<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/setting/form.blade.php ENDPATH**/ ?>