<div class="row topRow2">
    <?php
        $isCashCustomer = isset($transaction) && $transaction->customer && $transaction->customer->is_type === 'cash';
    ?>
    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="voucher_number"><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></label>
            <div class="input-group">
                <input type="text" class="form-control" name="voucher_number" 
                    value="<?php echo e(old($transaction->voucher_number ?? $invoice_number)); ?>" 
                    id="voucher_number" <?php if($isCashCustomer): ?> readonly <?php endif; ?> placeholder="<?php echo e($isCashCustomer ? 'Optional for cash customer' : 'Enter Estimate Number'); ?>">
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="customer_id"><?php echo app('translator')->get('quickadmin.transaction.fields.customer'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <select name="customer_id" class="form-control select2" id="customer_id"
                    onchange="toggleVoucherField(this)">
                    <option value="" disabled selected><?php echo app('translator')->get('quickadmin.order.fields.select_customer'); ?></option>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($customer->id); ?>" data-type="<?php echo e($customer->customer_type); ?>"
                            <?php echo e(isset($transaction) ? $transaction->customer_id == $customer->id ? 'selected' :'' :''); ?>

                            data-credit="<?php echo e(getTotalCredit($customer->id)); ?>" 
                            data-debit="<?php echo e(getTotalDebit($customer->id)); ?>" 
                            data-limit="<?php echo e($customer->credit_limit); ?>" >
                            <?php echo e($customer->full_name ?? ''); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>


    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="remain_balance"><?php echo app('translator')->get('quickadmin.transaction.fields.remain_balance'); ?></label>
            <div class="input-group">
                <input type="text" placeholder="0.00" value="<?php echo e(isset($transaction) ? $remainingbalance : "0.00"); ?>"  id="remain_balance" data-original-remain-bal="<?php echo e(isset($transaction) ? ($remainingbalance + $transaction->amount) : "0.00"); ?>" class="form-control" name="remain_balance" tabindex="1"  readonly>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6 col-lg-3">
        <div class="form-group">
            <label for="entry_date"><?php echo app('translator')->get('quickadmin.transaction.fields.entry-date'); ?><span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" class="form-control" name="entry_date" max="<?= date('Y-m-d'); ?>" id="entry_date" >
            </div>
        </div>
    </div>

    <div class="col-lg-12">        
        <div class="form-group">
            <label for="remark"><?php echo app('translator')->get('quickadmin.transaction.fields.remark'); ?></label>
            <div class="input-group">
                <input type="text" placeholder="Enter Remark" id="remark" class="form-control" name="remark" value="<?php echo e(isset($transaction) ? $transaction->remark : old('remark')); ?>" tabindex="1">
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div id="paymentContainer">
            <?php if(isset($transaction) && $transaction->cashReceiptAmounts->count()): ?>
                <?php $__currentLoopData = $transaction->cashReceiptAmounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row paymentRow topRow2 mb-3">
                        <div class="col-sm-6col-md-4 col-lg-4">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_mode'); ?><span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <select name="payment_way[]" class="form-control select2 payment_way">
                                        <?php $__currentLoopData = config('constant.transactions.payment_ways'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php echo e($row->payment_way == $key ? 'selected' : ''); ?>>
                                                <?php echo e($value ?? ''); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" id="original_amount" value="<?php echo e(isset($transaction) ? $transaction->amount : "0.00"); ?>">

                        <div class="col-sm-6 col-md-4 col-lg-4">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?><span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form-control amount" name="amount[]" id="amount" min="1" step="1" value="<?php echo e($row->amount); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="<?php echo app('translator')->get('quickadmin.qa_enter'); ?> <?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?>">
                                </div>
                                
                            </div>
                        </div>

                        <div class="col-md-2 col-lg-2 smright">
                            <button type="button" class="btn btn-success removePaymentBtn" <?php echo e($index == 0 ? 'style=display:none' : ''); ?>>
                                <i class="fas fa-minus"></i>
                            </button>
                            <?php if($index == 0): ?>
                                <button type="button" class="btn btn-success add_invoiceBtn" id="addPaymentBtn">
                                    <i class="fas fa-plus"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                
                <div class="row paymentRow topRow2 mb-3">
                    <div class="col-sm-6 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_mode'); ?><span class="text-danger">*</span></label>
                            <div class="input-group">
                                <select name="payment_way[]" class="form-control select2 payment_way">
                                    <?php $__currentLoopData = config('constant.transactions.payment_ways'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"><?php echo e($value ?? ''); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                            
                    <input type="hidden" id="original_amount" value="<?php echo e(isset($transaction) ? $transaction->amount : "0.00"); ?>">
                    <div class="col-sm-6 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?><span class="text-danger">*</span></label>
                            <div class="input-group">
                               <input type="text" class="form-control amount" name="amount[]" id="amount" min="1" step="1" value="<?php echo e(isset($transaction) ? $transaction->amount : old('amount')); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, ''); if(this.value.includes('-')) this.value = this.value.replace('-', ''); if(this.value.indexOf('.') !== -1) { var parts = this.value.split('.'); this.value = parts[0] + '.' + parts[1].slice(0, 2); }" placeholder="<?php echo app('translator')->get('quickadmin.qa_enter'); ?> <?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 col-lg-2 smright">
                        <button type="button" class="btn btn-success removePaymentBtn" style="display:none;">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-success add_invoiceBtn" id="addPaymentBtn" >
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="col-12 col-xl-12">        
        <div class="">
            <button type="submit" class="btn btn-submit-block btn-lg btn-block ml-auto" title="<?php echo app('translator')->get('quickadmin.qa_save'); ?>"><?php echo app('translator')->get('quickadmin.qa_save'); ?></button>
        </div>
    </div>
    
</div>

   
    
<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/payment_transactions/_form.blade.php ENDPATH**/ ?>