<div class="modal fade px-2" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle"><?php echo app('translator')->get('quickadmin.qa_view'); ?> Cash Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.order.fields.invoice_date'); ?></label>
                        <span class="text-capitalize" field-key='entry_date'><?php echo e($transaction->entry_date->format('d-m-Y')); ?></span>
                    </li>
                    <?php if(!empty($transaction->voucher_number)): ?>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></label>
                        <span class="text-capitalize" field-key='voucher_number'>#<?php echo e($transaction->voucher_number ?? ''); ?></span>
                    </li>
                    <?php endif; ?>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.particulars'); ?></label>
                        <span class="text-capitalize" field-key='remark'><?php echo e($transaction->remark ?? 'Cash Receipt'); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_type'); ?></label>
                        <span class="text-capitalize" field-key='payment_type'><?php echo e($transaction->payment_type ? ucfirst($transaction->payment_type) : ''); ?></span>
                    </li>
                    
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.qa_created_at'); ?></label>
                        <span class="text-capitalize" field-key='created_at'><?php echo e($transaction->created_at->format('d-m-Y H:i A')); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?></label>
                        <span class="text-capitalize" field-key='amount'><i class="fa fa-inr" aria-hidden="true"></i> <?php echo e(number_format($transaction->amount,2)); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.remark'); ?></label>
                        <span class="text-capitalize" field-key='remark'><?php echo e($transaction->remark ?? ''); ?></span>
                    </li>
                </ul>
                <?php if($transaction->cashReceiptAmounts->isNotEmpty()): ?>
                <div class="table-responsive mt-3">
                    <table class="table dataTable payment-transtion-table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('quickadmin.transaction.fields.sn'); ?></th>
                                <th><?php echo app('translator')->get('quickadmin.transaction.fields.payment_way'); ?></th>
                                <th><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transaction->cashReceiptAmounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e(config('constant.paymentModifyWays')[$row->payment_way] ?? $row->payment_way); ?></td>
                                    <td><?php echo e(number_format($row->amount, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted">
                                        <?php echo app('translator')->get('quickadmin.qa_no_entries_in_table'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>



<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/payment_transactions/show.blade.php ENDPATH**/ ?>