import type { Metadata } from "next";
import Link from "next/link";
import "./globals.css";
import 'bootstrap/dist/css/bootstrap.min.css';
import '../utils/css/styles.css';
import ClientLayout from "./ClientLayout";
import { fetchSettings } from "@/lib/apis/settings";

export const metadata: Metadata = {
  title: 'NPK(S) 15-15-15 - High-Quality Fertilizer for Agriculture',
  description:
    "NPK(S) 15-15-15 (10) - A complex universal fertilizer suitable for all types of soil and crops. Boost your crop yield with Cheminco's high-quality fertilizers.",
  icons: {
    icon: '/images/favicon.svg',
  },
  keywords: [
    'Cheminco',
    'Fertilizer',
    'NPK 15-15-15',
    'Agriculture',
    'Crop Booster',
    'Universal Fertilizer',
  ],
  authors: [{ name: 'Cheminco' }],

  openGraph: {
    title: 'NPK(S) 15-15-15 - High-Quality Fertilizer for Agriculture',
    description:
      'Boost your crop yield with NPK(S) 15-15-15 (10) - A universal fertilizer for all soils and crops.',
    url: 'https://yourwebsite.com/product-npk-15-15-15',
    siteName: 'Cheminco',
    images: [
      {
        url: 'https://yourwebsite.com/path-to-product-image.jpg',
        alt: 'NPK(S) 15-15-15 Product Image',
        width: 1200,
        height: 630,
      },
    ],
    locale: 'en_US',
    type: 'website', // You had 'product', but 'website' is the valid enum
  },

  twitter: {
    card: 'summary_large_image',
    title: 'NPK(S) 15-15-15 - High-Quality Fertilizer',
    description:
      "Boost your crop yield with Cheminco's NPK(S) 15-15-15 (10) - A universal fertilizer for all soils and crops.",
    images: ['https://yourwebsite.com/path-to-product-image.jpg'],
    site: '@cheminco', // optional
    creator: '@cheminco', // optional
  },
};

// ✅ Force this layout to always be Server-Side Rendered (SSR)
export const dynamic = 'force-dynamic';

export default async function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {

  const settings = await fetchSettings();
  return (
    <html lang="en">
      <body>
        <ClientLayout settings={settings}>

          {children}

        </ClientLayout>
      </body>
    </html>
  );
}
