import BreadCumb from "@/components/BreadCumb"
import Link from "next/link";
import { fetchSettings } from "@/lib/apis/settings";
import { mapSettingsByKey } from "@/lib/mapSettings";
import ImageComp from "@/components/Shared/Image";

export const metadata = {
    title: "Get In Touch",
    description: "Have questions or feedback? Reach out to our support team via this contact form.",
    openGraph: {
        title: "Contact Us",
        description: "Get in touch with us — we'd love to hear from you.",
        url: "https://yourdomain.com/contact-us",
    },
    twitter: {
        card: "summary",
        title: "Contact Us",
        description: "Reach out to our support team via this contact form.",
    },
};

export default async function OperationgProcedure() {
    return (
        <>
        <BreadCumb/>
                {/* add content the remove classes comingsoon-wrapper */}
            <section className="operationProcedures-wrapper py-120 comingsoon-wrapper"> 
                <div className="container">
                    {/* add content the remove classes comingsoon-text */}
                    <p className="products-dec-text text-center comingsoon-text">
                        Coming Soon
                    </p>
                </div>
            </section>
            <section className="transport-wrapper editData-inbox py-120 pt-0">
                <div className="ourproduct-shap">
                    <ImageComp src='/images/editData-ficon.webp' className="img-fluid" alt="editData-ficon" width={374} height={212}  />
                </div>
            </section>
        </>
    );
}