
import ImageComp from "@/components/Shared/Image";
import Link from "next/link";
import { fetchCategoryTypes } from "@/lib/apis/category-types";
import { asset } from "@/utils/asset";

export default async function Home() {  
  const categoryTypes = await fetchCategoryTypes();
  
  return (
          <>
            <div className="landing-wrapper">
              <div className="land-head">
                  <Link href="/" className="land-logo">
                      <ImageComp src="/images/landing-logo.webp" alt="logo" width={152} height={50} styleAuto={true} />
                  </Link>
              </div>
              <div className="land-hero">
                  <video autoPlay muted loop playsInline style={{
                    width: "100%",
                    height: "100%",
                    objectFit: "cover"
                  }} >
                      <source src="/images/Cheminco-Agricultural-Industrial-.mp4" type="video/mp4" />
                      Your browser does not support the video tag.
                  </video>
              </div>
              <section className="our-industries-wrapper">
                  <h2>Our Industries</h2>
                  <div className="smd-container">
                      <div className="row">
                          { (categoryTypes.length === 0 ) ? (
                            <>
                              <p>No Category Types</p>
                            </>
                          ) : 
                          (
                            categoryTypes.map((catType) => (
                              <div className="col-12 col-md-6" key={catType.id}>
                                <div className="our-industries-card">
                                    <div className="img-sm-box">
                                      <ImageComp src={asset(catType.categoryTypeUploads[0]?.file_path)} width={573} height={701} styleAuto={true} alt={`industry-${catType.slug}-img`} />
                                    </div>
                                    <Link href={`/${catType.slug}`} className="our-content">
                                        <h5>
                                          Cheminco <br/>
                                          {catType.title}
                                        </h5>
                                        <span>
                                          <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M10.6219 0.459323L17.5909 7.30715C17.7756 7.49737 17.868 7.72835 17.868 8.00008C17.868 8.27182 17.7756 8.5028 17.5909 8.69302L10.6219 15.5408C10.1468 15.9213 9.69801 15.9213 9.27564 15.5408C8.90608 15.0517 8.90608 14.5898 9.27564 14.155L14.5419 8.97835H1.07922C0.498471 8.924 0.181701 8.59791 0.128906 8.00008C0.181701 7.40226 0.498471 7.07617 1.07922 7.02182H14.5419L9.27564 1.84519C8.90608 1.41041 8.90608 0.948454 9.27564 0.459323C9.69801 0.0788887 10.1468 0.0788887 10.6219 0.459323Z" fill="white"/>
                                          </svg>
                                        </span>
                                    </Link>
                                </div>
                            </div>
                            ))
                          )
                          }
                          
                          {/* <div className="col-12 col-md-6">
                              <Link href="javascript:void(0)" className="our-industries-card">
                                  <div className="img-sm-box">
                                      <ImageComp src="/images/our-industries-img02.webp" width={573} height={701} styleAuto={true} alt="our-industries-img01" />
                                  </div>
                                  <div className="our-content">
                                      <h5>
                                          Cheminco Agricultural <br/>
                                          and Industrial
                                      </h5>
                                      <span>
                                          <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                              <path d="M10.6219 0.459323L17.5909 7.30715C17.7756 7.49737 17.868 7.72835 17.868 8.00008C17.868 8.27182 17.7756 8.5028 17.5909 8.69302L10.6219 15.5408C10.1468 15.9213 9.69801 15.9213 9.27564 15.5408C8.90608 15.0517 8.90608 14.5898 9.27564 14.155L14.5419 8.97835H1.07922C0.498471 8.924 0.181701 8.59791 0.128906 8.00008C0.181701 7.40226 0.498471 7.07617 1.07922 7.02182H14.5419L9.27564 1.84519C8.90608 1.41041 8.90608 0.948454 9.27564 0.459323C9.69801 0.0788887 10.1468 0.0788887 10.6219 0.459323Z" fill="white"/>
                                          </svg>                                        
                                      </span>
                                  </div>
                              </Link>
                          </div> */}
                      </div>
                  </div>

                  <div className="animation-gif">
                    <ImageComp src="/images/landing-animation.gif" alt="logo" width={159} height={238}/>
                  </div>
              </section>
          </div>
          </>
  );
}
