"use client";

import Link from 'next/link';
import { usePathname } from 'next/navigation';


// const capitalize = (s: string) => s.charAt(0).toUpperCase() + s.slice(1);
const capitalize = (s: string) => {
  const replaced = s.replace(/-/g, ' ');
  return replaced.charAt(0).toUpperCase() + replaced.slice(1);
};

interface BreadcumbProps {
    pageName?: string;
    productName?: string;
}

export default function BreadCumb({ pageName, productName } : BreadcumbProps){
    const pathname = usePathname();
    const pathSegments = pathname.split('/').filter(Boolean);
    let lastSegment = null;

// Conditionally add class for product and product-details
const isProductPage = pageName === "products" || pageName === "product-details";
const sectionClass = `subhero-wrapper${isProductPage ? " product-subhero" : ""}`;

    return (
        <>
            <section className={sectionClass}>
                <div className="container">
                    <div className="subhero-content">
                        <nav aria-label="breadcrumb">
                            <ol className="breadcrumb">
                                <li className="breadcrumb-item">
                                    <Link href="/" className="breadcrumb-link">Home</Link>
                                </li>

                                {pathSegments.map((segment, idx) => {
                                    
                                    const href = '/' + pathSegments.slice(0, idx + 1).join('/');
                                    const isLast = idx === pathSegments.length - 1;
                                    lastSegment = (isLast ? segment : "");
                                    if (segment == "products") {
                                        segment = "Our Products";
                                    }   
                                    return (
                                        idx != 3 && ( 
                                            <li key={href} className="breadcrumb-item active" aria-current="page">
                                                {!isLast ? (
                                                    <>
                                                    <Link href={href} className="breadcrumb-item active">
                                                        { capitalize(decodeURIComponent(segment)) }
                                                    </Link>
                                                    </>
                                                ) : (
                                                    <span className="text-gray-500">
                                                        {capitalize(decodeURIComponent(segment))}
                                                    </span>
                                                )}
                                            </li>
                                        )
                                    );
                                })}
                                    
                            </ol>
                        </nav>
                        <h1 className="subhero-title">
                            {(
                            lastSegment == 'our-products' ? "Our Products" :    
                            lastSegment == 'operating-procedure' ? "Operating Procedure" :    
                            lastSegment == 'services' ? "Our Services" : lastSegment == 'contact-us' ? "Contact Us" : ((pageName == 'products') ? "Agricultural Products" : (pageName == 'product-details' ? `${productName}` : "" ) ) )}
                        </h1>
                    </div>
                </div>
            </section>
        </>
    );
}