"use client";

import { useEffect, useRef, useState } from "react";
import Link from "next/link";
import ImageComp from "../Shared/Image";

export default function AboutSection(){

    const sectionRef = useRef(null);
    const [isActive, setIsActive] = useState(false);

    useEffect(() => {
        const observer = new IntersectionObserver(
            ([entry]) => {
                setIsActive(entry.isIntersecting);
            },
            { threshold: 0.3 }
        );

        if (sectionRef.current) {
            observer.observe(sectionRef.current);
        }

        return () => {
            if (sectionRef.current) {
                observer.unobserve(sectionRef.current);
            }
        };
    }, []);

    return (
        <section ref={sectionRef} className={`about-wrapper animated-section py-120 ${isActive ? "active" : ""}`}>
            <div className="container">
                <div className="row">
                    <div className="col-12 col-md-6 col-lg-5">
                        <div className="girdimges">
                            <div className="aboutshap-01">
                                <ImageComp src='/images/aboutimg-01.webp' alt="aboutimg-01" width={512} height={593} />
                            </div>
                            <div className="aboutshap-02">
                                <ImageComp src='/images/aboutimg-02.webp' alt="aboutimg-02" width={272} height={167} />
                            </div>
                            <div className="aboutshap-03">
                                <ImageComp src='/images/aboutimg-03.webp' alt="aboutimg-03" width={406} height={194} />
                            </div>
                        </div>
                    </div>
                    <div className="col-12 col-md-6 col-lg-7">
                        <div className="about-content subbox-data-content">
                            <div className="dim-text">
                                About Us
                            </div>
                            <h2 className="ds-title">
                                Our Business
                            </h2>
                            <p className="dec-text">
                                Cheminco is a trading company and service provider for the fast moving commodity industry covering Petroleum.
                                We are acting as an intermediary between customers and suppliers making complex transactions easy for buyers and sellers. 
                                At Cheminco, we work to identify economic, social, and political risks and assess their impact.  Our purpose is to secure optimal fuel supply deals, ensuring seamless and profitable engagements for all parties involved
                                With our global infrastructure and connections, we ensure our customers get their product in the right place, at the right time, and at the right price.
                            </p>
                            <p className="dec-text">
                                With our suppliers, we use our relationships and long-standing expert knowledge to ensure that manufacturer’s products are as per specifications and reach customers in the required destinations.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div className="animation-right">
                <ImageComp src='/images/petrochemicals-about-animation.webp' alt="petrochemicals-about-animation" width={341} height={145} />
            </div>
        </section>
        );
}