'use client';

import { useRef } from "react";
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';
import Link from "next/link";
import ImageComp from "../Shared/Image";

export default function HeroSection(){
    const swiperRef = useRef<any>(null);

    const handlePrev = () => {
        if (swiperRef.current) swiperRef.current.slidePrev();
    };

    const handleNext = () => {
        if (swiperRef.current) swiperRef.current.slideNext();
    };
    
    return (
        <>
        {/* video slider  */}
            <section className="hero-wrapper-video">
            <div className="land-hero">
                <video autoPlay muted loop playsInline style={{
                    width: "100%",
                    height: "100%",
                    objectFit: "cover"
                }} >
                    <source src="/images/cheminco_agricultural_industrial.mp4" type="video/mp4" />
                    Your browser does not support the video tag.
                </video>
            </div>
        </section>
        {/* video slider  */}
           {/* <section className="hero-wrapper py-120">
                <div className="lg-container">
                     <div className="row">
                        <div className="col-12 col-md-6">
                            <div className="hero-content">
                                <div className="hero-heading">
                                    <h1>
                                        <ImageComp className="favicon" src='/images/favicon.svg' alt="favicon" width={98} height={100} />
                                        Cheminco is a leading provider of Industrial Materials and Agricultural products
                                    </h1>
                                </div>
                                <div className="hero-text">
                                    <p>
                                        Providing industrial chemicals and fertilizers free from harmful cadmium and heavy metals—because purity matters.
                                    </p>
                                </div>
                                <div className="hero-btn">
                                    <Link href={""} className="btnprimary">
                                        Explore More
                                        <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clipPath="url(#clip0_2001_21)">
                                            <path d="M10.7027 2.77344L17.7742 9.33594C17.9617 9.51823 18.0554 9.73958 18.0554 10C18.0554 10.2604 17.9617 10.4818 17.7742 10.6641L10.7027 17.2266C10.2206 17.5911 9.76524 17.5911 9.33667 17.2266C8.96167 16.7578 8.96167 16.3151 9.33667 15.8984L14.6804 10.9375H1.01971C0.43042 10.8854 0.108991 10.5729 0.0554199 10C0.108991 9.42708 0.43042 9.11458 1.01971 9.0625H14.6804L9.33667 4.10156C8.96167 3.6849 8.96167 3.24219 9.33667 2.77344C9.76524 2.40885 10.2206 2.40885 10.7027 2.77344Z" fill="white"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_2001_21">
                                            <rect width="18" height="20" fill="white" transform="matrix(1 0 0 -1 0.0554199 20)"/>
                                            </clipPath>
                                            </defs>
                                        </svg>                                    
                                    </Link>
                                </div>
                            </div>
                        </div>
                        <div className="col-12 col-md-6">
                            <div className="heroslider-wrapper">
                                <Swiper
                                    modules={[Navigation]}
                                    loop={true}
                                    onSwiper={(swiper) => {
                                        swiperRef.current = swiper;
                                    }}
                                    spaceBetween={30}
                                    breakpoints={{
                                    0: {
                                        slidesPerView: 1,
                                    },
                                    600: {
                                        slidesPerView: 1,
                                    },
                                    1000: {
                                        slidesPerView: 1.7,
                                        spaceBetween: 30,
                                    },
                                    }}
                                    className="heroslider"
                                >
                                    <SwiperSlide>
                                        <div className="sliderimg">
                                            <ImageComp src='/images/heroslider01.webp' alt="heroslider01" width={474} height={633} styleAuto={false} />
                                        </div>
                                    </SwiperSlide>

                                    <SwiperSlide>
                                        <div className="sliderimg">
                                            <ImageComp src='/images/heroslider02.webp' alt="heroslider02" width={474} height={633} styleAuto={false} />
                                        </div>
                                    </SwiperSlide>

                                    <SwiperSlide>
                                        <div className="sliderimg">
                                            <ImageComp src='/images/heroslider01.webp' alt="heroslider01" width={474} height={633} styleAuto={false} />
                                        </div>
                                    </SwiperSlide>

                                    <SwiperSlide>
                                        <div className="sliderimg">
                                            <ImageComp src='/images/heroslider02.webp' alt="heroslider02" width={474} height={633} styleAuto={false} />
                                        </div>
                                    </SwiperSlide>
                                </Swiper>

                                
                                <div className="heroslider-slidearrows">
                                    <div onClick={handlePrev} className="heroslider-left-arrow">
                                        Previous
                                    </div>
                                    <div className="line-box"></div>
                                    <div onClick={handleNext} className="heroslider-right-arrow ">
                                        Next
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>                     
                </div>
            </section> */}
        </>
    );
}