'use client';

import HeroSection from "@/components/Home/Hero";
import AboutSection from "@/components/Home/About";
import WhatWeDoSection from "@/components/Home/WhatWeDo";
// import OurProductsClient from "@/components/Home/OurProductsClient";
import SaveCategoryType from "@/components/Home/SaveCategoryType";
import { Product } from "@/types/product";
import OurProductsSection from "../OurProducts";

interface AgriculturalContentProps {
    products: Product[];
    categoryType: string;
}

export default function AgriculturalContent({products,categoryType}:AgriculturalContentProps) {
    return (
        <>
            <HeroSection />
            
            <AboutSection />
    
            <WhatWeDoSection />
            
            <OurProductsSection products={products} categoryType={categoryType} />
        </>
    );
};