'use client';

import { useEffect, useState, useRef } from 'react';
import ImageComp from '../Shared/Image';
import { Product } from '@/types/product';
import { Navigation, EffectCards } from "swiper/modules";
import SwiperSlider from '../Products/SwiperSlider';
import ProductImage from '../Products/ProductImage';
import ProductDescription from '../Products/ProductDescription';
import ProductSlider from "@/components/Products/ProductsSlider";

interface ourProducts {
  products: Product[];
  categoryType: string;
}

export default function OurProductsSection({ products, categoryType }: ourProducts){
    const [isClient, setIsClient] = useState(false);

    useEffect(() => {
        setIsClient(true);
    }, []);
    
    const prevRef = useRef<HTMLButtonElement | null>(null);
    const nextRef = useRef<HTMLButtonElement | null>(null);

    const slides = products.map(product => (
        <div className="product-box">
            <div className="product-img">
                <ProductImage image_path={product.productUploads[0]?.file_path} title={product.title ?? 'product image'} width={194} height={411} />
            </div>
            <div className="product-name">
                <h4>{product.title}</h4>
                <ProductDescription html={product.description} />
            </div>
        </div>
    ));

    if (!isClient) return null;

    return (

        <section className="our-product-wrapper py-120">
        <div className="container">
            <div className="row">
                <div className="col-12">
                    <div className="left-ourproduct">
                        <h2 className="dim-text">
                            Our Products
                        </h2>
                        <p className="dec-text">
                            Cheminco also offers customized nutrient solutions tailored to specific crop needs and regional conditions, ensuring optimal results for farmers regardless of scale. With a growing network of trusted partners, we continue to deliver value, consistency, and sustainability to agricultural communities worldwide.
                        </p>
                        
                    </div>
                </div>
                <div className="col-12">
                    <div className="our-product-slider">
                        {/* {products.length > 0 && (
                            <>
                            <SwiperSlider
                                modules = {[Navigation, EffectCards]}
                                navigation={{
                                    nextEl: ".our-productslider-right-arrow",
                                    prevEl: ".our-productslider-left-arrow"
                                }}
                                slidesPerView={1}
                                className="our-products"
                                grabCursor={true}
                                slides={slides}
                                effectName="cards"
                                cardsEffect={{
                                    perSlideOffset: 20,
                                    perSlideRotate: 0,
                                    slideShadows: false
                                }}
                                section_name='our-products'
                            />

                            <div className="our-productslider-slidearrows">
                                <div className="our-productslider-left-arrow">
                                    <svg width="21" height="24" viewBox="0 0 21 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.57812 3.32812L0.328125 11.2031C0.109375 11.4219 0 11.6875 0 12C0 12.3125 0.109375 12.5781 0.328125 12.7969L8.57812 20.6719C9.14062 21.1094 9.67188 21.1094 10.1719 20.6719C10.6094 20.1094 10.6094 19.5781 10.1719 19.0781L3.9375 13.125H19.875C20.5625 13.0625 20.9375 12.6875 21 12C20.9375 11.3125 20.5625 10.9375 19.875 10.875H3.9375L10.1719 4.92188C10.6094 4.42188 10.6094 3.89062 10.1719 3.32812C9.67188 2.89062 9.14062 2.89062 8.57812 3.32812Z" fill="currentcolor"/>
                                    </svg>                                                                                                                               
                                </div>
                                <div className="line-box"></div>
                                <div className="our-productslider-right-arrow">
                                    <svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.4219 0.328125L20.6719 8.20312C20.8906 8.42188 21 8.6875 21 9C21 9.3125 20.8906 9.57812 20.6719 9.79688L12.4219 17.6719C11.8594 18.1094 11.3281 18.1094 10.8281 17.6719C10.3906 17.1094 10.3906 16.5781 10.8281 16.0781L17.0625 10.125H1.125C0.4375 10.0625 0.0625 9.6875 0 9C0.0625 8.3125 0.4375 7.9375 1.125 7.875H17.0625L10.8281 1.92188C10.3906 1.42188 10.3906 0.890625 10.8281 0.328125C11.3281 -0.109375 11.8594 -0.109375 12.4219 0.328125Z" fill="currentcolor"/>
                                    </svg>                                                                                              
                                </div>
                            </div>
                            </>
                        )} */}
                    </div>
                    <section className="our-product-slide py-120 pt-0">
                        <ProductSlider categoryType={categoryType} products={products ?? []} subcategorySlug={null} categorySlug={null} isHomePage={true} />
                    </section>
                </div>
            </div>
        </div>
        <div className="ourproduct-shap">
            <ImageComp src='/images/ourproduct-shap02.webp' alt="ourproduct-shap02" width={107} height={133} />
        </div>
    </section>
    );
}