'use client';

import Link from "next/link";
import ImageComp from "../Shared/Image";

export default function WhatWeDoSection(){
    return (
        <section className="what-wedo-wrapper">
            <div className="section-first py-120 pb-0">
                <div className="container">
                    <div className="row">
                        <div className="col-12 col-md-6 col-lg-5">
                            <div className="leftsection-data">
                                <div className="gridimg-inner">
                                    <div className="shap01">
                                        <ImageComp src='/images/whatwedo-img01.webp' alt="whatwedo-img01" width={554} height={581}  />
                                    </div>
                                    <div className="shap02">
                                        <ImageComp src='/images/whatwedo-img02.webp' alt="whatwedo-img02" width={322} height={366} />
                                    </div>
                                    <div className="shap03">
                                        <ImageComp src='/images/whatwedo-shap02.webp' alt="whatwedo-shap02" width={88} height={108}/>
                                    </div>
                                    <div className="shap04">
                                        <ImageComp src='/images/whatwedo-shap03.webp' alt="whatwedo-shap03" width={148} height={67}/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className="col-12 col-md-6 col-lg-7">
                            <div className="we-do-content subbox-data-content">
                                <div className="dim-text">
                                    What we do
                                </div>
                                <h2 className="ds-title">
                                    Agricultural Products
                                </h2>
                                <p className="dec-text">
                                    Our range of environmentally safe fertilisers and nutrients help farmers from many countries across three continents to improve their crop quality and yields. 
                                    </p>
                                <p className="dec-text">
                                    Majority of our manufacturers are vertically integrated companies with flexible production capacities that allow Cheminco an access to a large range of fertilisers and crop nutrients for supply to clients across Asia-Pacific, Europe and Central Asia.
                                </p>
                                <div className="primary-btn">
                                    <Link href="/agricultural-and-industrial/products" className="btnprimary">
                                        Explore More
                                        <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clipPath="url(#clip0_2001_21)">
                                            <path d="M10.7027 2.77344L17.7742 9.33594C17.9617 9.51823 18.0554 9.73958 18.0554 10C18.0554 10.2604 17.9617 10.4818 17.7742 10.6641L10.7027 17.2266C10.2206 17.5911 9.76524 17.5911 9.33667 17.2266C8.96167 16.7578 8.96167 16.3151 9.33667 15.8984L14.6804 10.9375H1.01971C0.43042 10.8854 0.108991 10.5729 0.0554199 10C0.108991 9.42708 0.43042 9.11458 1.01971 9.0625H14.6804L9.33667 4.10156C8.96167 3.6849 8.96167 3.24219 9.33667 2.77344C9.76524 2.40885 10.2206 2.40885 10.7027 2.77344Z" fill="white"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_2001_21">
                                            <rect width="18" height="20" fill="white" transform="matrix(1 0 0 -1 0.0554199 20)"/>
                                            </clipPath>
                                            </defs>
                                        </svg>
                                    </Link>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div className="section-second py-120">
                <div className="container">
                    <div className="row">
                        <div className="col-12 col-md-6 col-lg-7">
                                <div className="we-do-content subbox-data-content">
                                    <h2 className="ds-title">
                                        Industrial Chemicals
                                    </h2>
                                    <p className="dec-text">
                                        Being  providers of raw materials for the production of civil explosives we understand the intricate realm of mining, where innovation and safety are paramount and the role of explosives cannot be overstated. Mining companies, in collaboration with explosives manufacturers that use our materials, are continuously striving to develop advanced formulations that maximize efficiency while minimizing environmental impact.
                                        <br />
                                        Phosphoric acid is used in the manufacture of superphosphate fertilizers, livestock feeds, phosphate salts, polyphosphates, soaps, waxes, polishes and detergents. It is also used in the manufacture of fire control agents, electric lights, in cotton dyeing  and many more applications.
                                        <br />
                                    </p>
                                        <p className="dec-text">
                                        Industrial Phosphates: Industrial uses include water softening, rust proofing, fire proofing, in insecticides and detergents, and for the manufacture of elemental phosphorus.
                                    </p>
                                    <div className="primary-btn">
                                        <Link href="/our-products" className="btnprimary">
                                            Explore More
                                            <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clipPath="url(#clip0_2001_21)">
                                                <path d="M10.7027 2.77344L17.7742 9.33594C17.9617 9.51823 18.0554 9.73958 18.0554 10C18.0554 10.2604 17.9617 10.4818 17.7742 10.6641L10.7027 17.2266C10.2206 17.5911 9.76524 17.5911 9.33667 17.2266C8.96167 16.7578 8.96167 16.3151 9.33667 15.8984L14.6804 10.9375H1.01971C0.43042 10.8854 0.108991 10.5729 0.0554199 10C0.108991 9.42708 0.43042 9.11458 1.01971 9.0625H14.6804L9.33667 4.10156C8.96167 3.6849 8.96167 3.24219 9.33667 2.77344C9.76524 2.40885 10.2206 2.40885 10.7027 2.77344Z" fill="white"/>
                                                </g>
                                                <defs>
                                                <clipPath id="clip0_2001_21">
                                                <rect width="18" height="20" fill="white" transform="matrix(1 0 0 -1 0.0554199 20)"/>
                                                </clipPath>
                                                </defs>
                                            </svg>
                                        </Link>
                                    </div>
                                </div>
                            </div>
                            <div className="col-12 col-md-6 col-lg-5">
                                <div className="leftsection-data">
                                    <div className="gridimg-inner">
                                        <div className="shap01">
                                            <ImageComp src='/images/whatwedo-img03.webp' alt="whatwedo-img03" width={554} height={581} />
                                            </div>
                                            <div className="shap02">
                                                <ImageComp src='/images/whatwedo-img04.webp' alt="whatwedo-img04" width={322} height={366} />
                                            </div>
                                            <div className="shap03">
                                                <ImageComp src='/images/whatwedo-shap02.webp' alt="whatwedo-shap02" width={91} height={112} />
                                            </div>
                                            <div className="shap04">
                                                <ImageComp src='/images/whatwedo-shap03.webp' alt="whatwedo-shap03" width={148} height={67} />
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                </div>
                <div className="producshap-icon up-down">
                    <ImageComp src='/images/whatwedo-shap05.webp' alt="whatwedo-shap05" width={138} height={111} />
                </div>
            </div>
        </section>
    );
}