"use client";

import ImageComp from './Shared/Image';
import Link from 'next/link';
import { useState, useEffect, useRef } from 'react';
import { usePathname } from 'next/navigation';
import { isActive } from '@/utils/nav';
import { Category } from '@/types/category';
import GoogleTranslateWidget from "../components/languageTranslate/GoogleTranslateWidget";
import { getCategoryType } from '@/lib/storage';
import { fetchCategories } from '@/lib/apis/categories';

export default function Navbar() {
    const [categoryType, setCategoryType] = useState<string | undefined>(undefined);
    const [navCategories, setNavCategories] = useState<Category[]>([]);
    const [loading, setLoading] = useState(true);
    const pathname = usePathname();

    useEffect(() => {
        require('bootstrap/dist/js/bootstrap.bundle.min.js');
        const menus = document.querySelectorAll(' .navbar-collapse .dropdown-menu');
        menus.forEach(menu => {
          menu.addEventListener('click', (e) => {
            e.stopPropagation();
          });
        });

        const categoryType = getCategoryType();
        if(categoryType){
            // setCategoryType(categoryType);
            setCategoryType("agricultural-and-industrial");
        }

        const fetchData = async () => {
          try {
            if(categoryType){
              // const result = await fetchCategories(categoryType);
              const result = await fetchCategories("agricultural-and-industrial");
              setNavCategories(result);
            }
          } finally {
            setLoading(false);
          }
        };
      
        fetchData();
        
      }, []);

  

    const [isSubMenuOpen, setIsSubMenuOpen] = useState(false); // Assuming this is your state

    const handleSubMenuToggle = () => {
      setIsSubMenuOpen(!isSubMenuOpen); // Correctly using the state setter
    };

     const isActiveLink = (path: string) => {
        return pathname === path;
    };

  return (
    <header>
      <nav className="navbar navbar-expand-lg">
        <div className="container">
          <Link className="brandlogo" href="/">
            <ImageComp src='/images/logo.png' alt="logo" width={228} height={62} priority={true}  />
          </Link>
          <button
            className="navbar-toggler"
            type="button"
            data-bs-toggle="collapse"
            data-bs-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent"
            aria-expanded="false"
            aria-label="Toggle navigation"
          >
            <span className="navbar-toggler-icon"></span>
          </button>

          <div className="collapse navbar-collapse" id="navbarSupportedContent">
            <ul className="navbar-nav m-auto mb-2 mb-lg-0">
              <li className="nav-item">
               { pathname.startsWith("/petrochemicals") ||  pathname == "/our-products"  || pathname == "/operating-procedure" ?(
                <Link className={`nav-link ${(pathname == '/petrochemicals') ? 'active' : ''}`} href="/petrochemicals">Home</Link>                
              ):(
                <Link className={`nav-link ${(pathname == '/agricultural-and-industrial') ? 'active' : ''}`} href="/agricultural-and-industrial">Home</Link>
              )}
              </li>
            {
             pathname.startsWith("/petrochemicals") ||  pathname == "/our-products"  || pathname == "/operating-procedure" ?(
                <>
                  <li className="nav-item">
                    <Link className={`nav-link ${isActive(pathname, '/our-products') ? 'active' : ''}`} href="/our-products">Our Products</Link>
                  </li>
                  <li className="nav-item">
                    <Link className={`nav-link ${isActive(pathname, '/operating-procedure') ? 'active' : ''}`} href="/operating-procedure">Operating Procedure</Link>
                  </li>
                </>
              ):(
                <>
                  <li className="nav-item dropdown">
                    <Link
                      className= {`nav-link dropdown-toggle ${(pathname.startsWith('/agricultural-and-industrial/products')) ? 'active' : ''}`}
                      href="#"
                      role="button"
                      data-bs-toggle="dropdown"
                      aria-expanded="false"
                    >
                      Our products
                    </Link>

                    <ul className="dropdown-menu">
                      {navCategories.length > 0 && (
                          <>
                          {navCategories.map((cat) => (
                            <li className='dropdown-menu-list dropdown' key={cat.id}>
                                {cat.sub_categories.length > 0 ? (
                                    <>
                                        <Link
                                            className={`dropdown-item dropdown-toggle subdropdown-item ${(pathname.startsWith(`/agricultural-and-industrial/products/${cat.slug}`)) ? 'active' : ''}`}
                                            href={`#collapseCategory${cat.id}`}
                                            data-bs-toggle="dropdown"
                                            aria-expanded="false"
                                            >
                                            {cat.title ?? ''}
                                        </Link>
                                        <ul className="dropdown-menu sub-dropdown-menu">
                                            {cat.sub_categories.map((subcat) => (
                                                <li className="" key={subcat.id}>
                                                    <Link
                                                        className={`dropdown-item ${(pathname.startsWith(`/agricultural-and-industrial/products/${cat.slug}/${subcat.slug}`)) ? 'active' : ''}`}
                                                        href={`/${categoryType}/products/${cat.slug}/${subcat.slug}`}
                                                    >
                                                        {subcat.title ?? ''}
                                                    </Link>
                                                </li>
                                            ))}
                                        </ul>
                                    </>
                                ) : (
                                    <Link
                                        className={`dropdown-item`}
                                        href={`/${categoryType}/products/${cat.slug}`}
                                    >
                                      {cat.title}
                                    </Link>
                                )}                                
                            </li>
                          ))}                      
                          </>
                      )}
                    </ul>
                  </li>
                  <li className="nav-item">
                    <Link className={`nav-link ${isActive(pathname, '/services') ? 'active' : ''}`} href="/services">Services</Link>
                  </li>
                  <li className="nav-item">
                    <Link className={`nav-link ${isActive(pathname, '/contact-us') ? 'active' : ''}`} href="/contact-us">Contact Us</Link>
                  </li>
                </>
              )
            }


              
            </ul>
          </div>

          {/* Language Switcher */}

          <div className="country-dropdown">
            <GoogleTranslateWidget/>
          </div>

        </div>
      </nav>
    </header>
  );
}
